/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import sun.misc.Launcher;

class InstallDialog
extends Dialog
implements ActionListener {
    private ImageIcon background;
    private TextField installField = new TextField();
    private Button ok = new Button(InstallDialog.R("ButOk"));
    private Button cancel = new Button(InstallDialog.R("ButCancel"));
    private Button browse = new Button(InstallDialog.R("ButBrowse"));
    private boolean canceled = false;

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    static Frame createFrame() {
        Frame f = new Frame();
        f.setIconImage(JNLPRuntime.getWindowIcon());
        return f;
    }

    InstallDialog() {
        super(InstallDialog.createFrame(), InstallDialog.R("CChooseCache"), true);
        URL icon = new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/install.png");
        this.background = new ImageIcon(icon);
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        String home = System.getProperty("java.io.tmpdir");
        this.installField.setText(new File(home).toString());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.browse.addActionListener(this);
        Font f = new Font("SansSerif", 1, 14);
        this.installField.setFont(f);
        this.ok.setFont(f);
        this.cancel.setFont(f);
        this.browse.setFont(f);
        Panel top = new Panel(new GridLayout(2, 1, 0, 10));
        Label l1 = new Label(InstallDialog.R("CChooseCacheInfo"));
        Label l2 = new Label(InstallDialog.R("CChooseCacheDir") + ":");
        l1.setFont(f);
        l2.setFont(f);
        top.add(l1);
        top.add(l2);
        Panel field = new Panel(new BorderLayout());
        field.add((Component)top, "North");
        field.add((Component)this.installField, "Center");
        field.add((Component)this.browse, "East");
        Panel grid = new Panel(new GridLayout(1, 2, 8, 8));
        grid.add(this.ok);
        grid.add(this.cancel);
        Panel choice = new Panel(new FlowLayout(1, 4, 0));
        choice.add(grid);
        this.add((Component)field, "North");
        this.add((Component)new Panel(), "Center");
        this.add((Component)choice, "South");
    }

    @Override
    public Insets getInsets() {
        Insets s = super.getInsets();
        return new Insets(s.top + 55, s.left + 7, s.bottom + 6, s.right + 4);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.background == null) {
            return d;
        }
        Insets in = super.getInsets();
        d.width = this.background.getIconWidth() + in.left + in.right;
        d.height = Math.max(d.height + 8, this.background.getIconHeight() + 8 + in.top + in.bottom);
        return d;
    }

    @Override
    public void paint(Graphics g) {
        Insets sin = super.getInsets();
        g.drawImage(this.background.getImage(), sin.left, sin.top, this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.cancel) {
            this.canceled = true;
            this.dispose();
        }
        if (evt.getSource() == this.ok) {
            File f = new File(this.installField.getText());
            try {
                f.mkdirs();
                this.dispose();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Install directory cannot be created.", "ERROR", 0);
            }
        }
        if (evt.getSource() == this.browse) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            int r = fc.showOpenDialog(this);
            if (r == 0) {
                this.installField.setText(fc.getSelectedFile().toString());
            }
        }
    }

    static File getInstallDir() {
        InstallDialog id = new InstallDialog();
        id.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        id.setLocation(screen.width / 2 - id.getWidth() / 2, screen.height / 2 - id.getHeight() / 2);
        id.setVisible(true);
        if (id.canceled) {
            return null;
        }
        return new File(id.installField.getText());
    }
}

