/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Image;
import java.io.File;
import java.security.Policy;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.jnlp.ServiceManager;
import javax.swing.ImageIcon;
import net.sourceforge.jnlp.DefaultLaunchHandler;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.cache.DefaultDownloadIndicator;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.InstallDialog;
import net.sourceforge.jnlp.runtime.JNLPPolicy;
import net.sourceforge.jnlp.runtime.JNLPSecurityManager;
import net.sourceforge.jnlp.services.XServiceManagerStub;
import net.sourceforge.jnlp.util.PropertiesFile;
import sun.misc.Launcher;

public class JNLPRuntime {
    private static ResourceBundle resources;
    private static JNLPSecurityManager security;
    private static JNLPPolicy policy;
    private static File baseDir;
    private static LaunchHandler handler;
    private static DownloadIndicator indicator;
    private static UpdatePolicy updatePolicy;
    private static Image windowIcon;
    private static boolean initialized;
    private static boolean headless;
    private static boolean verify;
    private static boolean securityEnabled;
    private static boolean debug;
    public static Object initMutex;

    public static boolean isInitialized() {
        return initialized;
    }

    public static void initialize() throws IllegalStateException {
        JNLPRuntime.checkInitialized();
        if (!headless) {
            JNLPRuntime.checkHeadless();
        }
        if (!headless && windowIcon == null) {
            JNLPRuntime.loadWindowIcon();
        }
        if (!headless && indicator == null) {
            indicator = new DefaultDownloadIndicator();
        }
        if (handler == null) {
            handler = new DefaultLaunchHandler();
        }
        if (baseDir == null) {
            baseDir = JNLPRuntime.getDefaultBaseDir();
        }
        if (baseDir == null) {
            throw new IllegalStateException(JNLPRuntime.getMessage("BNoBase"));
        }
        ServiceManager.setServiceManagerStub(new XServiceManagerStub());
        policy = new JNLPPolicy();
        security = new JNLPSecurityManager();
        if (securityEnabled) {
            Policy.setPolicy(policy);
            System.setSecurityManager(security);
        }
        initialized = true;
    }

    public static Image getWindowIcon() {
        return windowIcon;
    }

    public static void setWindowIcon(Image image) {
        JNLPRuntime.checkExitClass();
        windowIcon = image;
    }

    public static boolean isHeadless() {
        return headless;
    }

    public static boolean isVerifying() {
        return verify;
    }

    public static void setHeadless(boolean enabled) {
        JNLPRuntime.checkInitialized();
        headless = enabled;
    }

    public static void setVerify(boolean enabled) {
        JNLPRuntime.checkInitialized();
        verify = enabled;
    }

    public static File getBaseDir() {
        return baseDir;
    }

    public static void setBaseDir(File baseDirectory) {
        JNLPRuntime.checkInitialized();
        baseDir = baseDirectory;
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static void setSecurityEnabled(boolean enabled) {
        JNLPRuntime.checkInitialized();
        securityEnabled = enabled;
    }

    public static File getDefaultBaseDir() {
        PropertiesFile props = JNLPRuntime.getProperties();
        JNLPRuntime.loadWindowIcon();
        String baseStr = props.getProperty("basedir");
        if (baseStr != null) {
            return new File(baseStr);
        }
        if (JNLPRuntime.isHeadless()) {
            return null;
        }
        File baseDir = InstallDialog.getInstallDir();
        if (baseDir == null) {
            return null;
        }
        props.setProperty("basedir", baseDir.toString());
        props.store();
        return baseDir;
    }

    public static void setExitClass(Class exitClass) {
        JNLPRuntime.checkExitClass();
        security.setExitClass(exitClass);
    }

    public static void disableExit() {
        security.disableExit();
    }

    public static ApplicationInstance getApplication() {
        return security.getApplication();
    }

    public static PropertiesFile getProperties() {
        File netxrc = new File(System.getProperty("user.home"), ".netxrc");
        return new PropertiesFile(netxrc);
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean enabled) {
        JNLPRuntime.checkExitClass();
        debug = enabled;
    }

    public static void setDefaultUpdatePolicy(UpdatePolicy policy) {
        JNLPRuntime.checkExitClass();
        updatePolicy = policy;
    }

    public static UpdatePolicy getDefaultUpdatePolicy() {
        return updatePolicy;
    }

    public static void setDefaultLaunchHandler(LaunchHandler handler) {
        JNLPRuntime.checkExitClass();
        JNLPRuntime.handler = handler;
    }

    public static LaunchHandler getDefaultLaunchHandler() {
        return handler;
    }

    public static void setDefaultDownloadIndicator(DownloadIndicator indicator) {
        JNLPRuntime.checkExitClass();
        JNLPRuntime.indicator = indicator;
    }

    public static DownloadIndicator getDefaultDownloadIndicator() {
        return indicator;
    }

    public static String getMessage(String key) {
        try {
            String result = resources.getString(key);
            if (result.length() == 0) {
                return null;
            }
            return result;
        }
        catch (Exception ex) {
            if (!key.equals("RNoResource")) {
                return JNLPRuntime.getMessage("RNoResource", new Object[]{key});
            }
            return "Missing resource: " + key;
        }
    }

    public static String getMessage(String key, Object[] args) {
        return MessageFormat.format(JNLPRuntime.getMessage(key), args);
    }

    private static void checkInitialized() {
        if (initialized) {
            throw new IllegalStateException("JNLPRuntime already initialized.");
        }
    }

    private static void checkExitClass() {
        if (securityEnabled && initialized && !security.isExitClass()) {
            throw new IllegalStateException("Caller is not the exit class");
        }
    }

    private static void checkHeadless() {
        try {
            if ("true".equalsIgnoreCase(System.getProperty("java.awt.headless"))) {
                headless = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static void loadResources() {
        try {
            resources = ResourceBundle.getBundle("net.sourceforge.jnlp.resources.Messages");
        }
        catch (Exception ex) {
            throw new IllegalStateException("Missing resource bundle in netx.jar:net/sourceforge/jnlp/resource/Messages.properties");
        }
    }

    private static void loadWindowIcon() {
        block3: {
            if (windowIcon != null) {
                return;
            }
            try {
                windowIcon = new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/netx-icon.png")).getImage();
            }
            catch (Exception ex) {
                if (!JNLPRuntime.isDebug()) break block3;
                ex.printStackTrace();
            }
        }
    }

    static {
        JNLPRuntime.loadResources();
        handler = null;
        indicator = null;
        updatePolicy = UpdatePolicy.ALWAYS;
        windowIcon = null;
        initialized = false;
        headless = false;
        verify = true;
        securityEnabled = true;
        debug = false;
        initMutex = new Object();
    }
}

