/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDnDConstants;
import sun.awt.X11.XDragSourceContextPeer;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class XDnDDragSourceProtocol
extends XDragSourceProtocol {
    private static final Logger logger = Logger.getLogger("sun.awt.X11.xembed.xdnd.XDnDDragSourceProtocol");
    private static final Unsafe unsafe = XlibWrapper.unsafe;

    protected XDnDDragSourceProtocol(XDragSourceProtocolListener listener) {
        super(listener);
    }

    static XDragSourceProtocol createInstance(XDragSourceProtocolListener listener) {
        return new XDnDDragSourceProtocol(listener);
    }

    public String getProtocolName() {
        return "XDnD";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDragImpl(int actions2, Transferable contents, Map formatMap, long[] formats) throws InvalidDnDOperationException, IllegalArgumentException, XException {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        long window = XDragSourceProtocol.getDragSourceWindow();
        long data = Native.allocateLongArray(3);
        int action_count = 0;
        try {
            if ((actions2 & 1) != 0) {
                Native.putLong(data, action_count, XDnDConstants.XA_XdndActionCopy.getAtom());
                ++action_count;
            }
            if ((actions2 & 2) != 0) {
                Native.putLong(data, action_count, XDnDConstants.XA_XdndActionMove.getAtom());
                ++action_count;
            }
            if ((actions2 & 0x40000000) != 0) {
                Native.putLong(data, action_count, XDnDConstants.XA_XdndActionLink.getAtom());
                ++action_count;
            }
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XDnDConstants.XA_XdndActionList.setAtomData(window, 4L, data, action_count);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                this.cleanup();
                throw new XException("Cannot write XdndActionList property");
            }
        }
        finally {
            unsafe.freeMemory(data);
            data = 0L;
        }
        data = Native.allocateLongArray(formats.length);
        try {
            Native.put(data, formats);
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XDnDConstants.XA_XdndTypeList.setAtomData(window, 4L, data, formats.length);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                this.cleanup();
                throw new XException("Cannot write XdndActionList property");
            }
        }
        finally {
            unsafe.freeMemory(data);
            data = 0L;
        }
        if (!XDnDConstants.XDnDSelection.setOwner(contents, formatMap, formats, 0L)) {
            this.cleanup();
            throw new InvalidDnDOperationException("Cannot acquire selection ownership");
        }
    }

    private boolean processXdndStatus(XClientMessageEvent xclient) {
        int action = 0;
        if (xclient.get_data(0) != this.getTargetWindow()) {
            return true;
        }
        if ((xclient.get_data(1) & 1L) != 0L) {
            action = XDnDConstants.getJavaActionForXDnDAction(xclient.get_data(4));
        }
        this.getProtocolListener().handleDragReply(action);
        return true;
    }

    private boolean processXdndFinished(XClientMessageEvent xclient) {
        if (xclient.get_data(0) != this.getTargetWindow()) {
            return true;
        }
        if (this.getTargetProtocolVersion() >= 5) {
            boolean success = (xclient.get_data(1) & 1L) != 0L;
            int action = XDnDConstants.getJavaActionForXDnDAction(xclient.get_data(2));
            this.getProtocolListener().handleDragFinished(success, action);
        } else {
            this.getProtocolListener().handleDragFinished();
        }
        this.finalizeDrop();
        return true;
    }

    public boolean processClientMessage(XClientMessageEvent xclient) {
        if (xclient.get_message_type() == XDnDConstants.XA_XdndStatus.getAtom()) {
            return this.processXdndStatus(xclient);
        }
        if (xclient.get_message_type() == XDnDConstants.XA_XdndFinished.getAtom()) {
            return this.processXdndFinished(xclient);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XDragSourceProtocol.TargetWindowInfo getTargetWindowInfo(long window) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        WindowPropertyGetter wpg1 = new WindowPropertyGetter(window, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
        int status = wpg1.execute(XToolkit.IgnoreBadWindowHandler);
        if (status == 0 && wpg1.getData() != 0L && wpg1.getActualType() == 4L) {
            int targetVersion = (int)Native.getLong(wpg1.getData());
            wpg1.dispose();
            if (targetVersion >= 3) {
                int protocolVersion;
                long proxy;
                block18: {
                    proxy = 0L;
                    protocolVersion = targetVersion < 5 ? targetVersion : 5;
                    WindowPropertyGetter wpg2 = new WindowPropertyGetter(window, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                    try {
                        status = wpg2.execute(XToolkit.IgnoreBadWindowHandler);
                        if (status == 0 && wpg2.getData() != 0L && wpg2.getActualType() == 33L) {
                            proxy = Native.getLong(wpg2.getData());
                        }
                    }
                    finally {
                        wpg2.dispose();
                    }
                    if (proxy != 0L) {
                        WindowPropertyGetter wpg3 = new WindowPropertyGetter(proxy, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                        try {
                            status = wpg3.execute(XToolkit.IgnoreBadWindowHandler);
                            if (status != 0 || wpg3.getData() == 0L || wpg3.getActualType() != 33L || Native.getLong(wpg3.getData()) != proxy) {
                                proxy = 0L;
                                break block18;
                            }
                            WindowPropertyGetter wpg4 = new WindowPropertyGetter(proxy, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
                            try {
                                status = wpg4.execute(XToolkit.IgnoreBadWindowHandler);
                                if (status != 0 || wpg4.getData() == 0L || wpg4.getActualType() != 4L) {
                                    proxy = 0L;
                                }
                            }
                            finally {
                                wpg4.dispose();
                            }
                        }
                        finally {
                            wpg3.dispose();
                        }
                    }
                }
                return new XDragSourceProtocol.TargetWindowInfo(proxy, protocolVersion);
            }
        } else {
            wpg1.dispose();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEnterMessage(long[] formats, int sourceAction, int sourceActions, long time) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        assert (formats != null);
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(this.getTargetWindow());
            msg.set_format(32);
            msg.set_message_type(XDnDConstants.XA_XdndEnter.getAtom());
            msg.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            long data1 = this.getTargetProtocolVersion() << 24;
            msg.set_data(1, data1 |= formats.length > 3 ? 1L : 0L);
            msg.set_data(2, formats.length > 0 ? formats[0] : 0L);
            msg.set_data(3, formats.length > 1 ? formats[1] : 0L);
            msg.set_data(4, formats.length > 2 ? formats[2] : 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, msg.pData);
        }
        finally {
            msg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMoveMessage(int xRoot, int yRoot, int sourceAction, int sourceActions, long time) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(this.getTargetWindow());
            msg.set_format(32);
            msg.set_message_type(XDnDConstants.XA_XdndPosition.getAtom());
            msg.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            msg.set_data(1, 0L);
            msg.set_data(2, xRoot << 16 | yRoot);
            msg.set_data(3, time);
            msg.set_data(4, XDnDConstants.getXDnDActionForJavaAction(sourceAction));
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, msg.pData);
        }
        finally {
            msg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLeaveMessage(long time) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(this.getTargetWindow());
            msg.set_format(32);
            msg.set_message_type(XDnDConstants.XA_XdndLeave.getAtom());
            msg.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            msg.set_data(1, 0L);
            msg.set_data(2, 0L);
            msg.set_data(3, 0L);
            msg.set_data(4, 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, msg.pData);
        }
        finally {
            msg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDropMessage(int xRoot, int yRoot, int sourceAction, int sourceActions, long time) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(this.getTargetWindow());
            msg.set_format(32);
            msg.set_message_type(XDnDConstants.XA_XdndDrop.getAtom());
            msg.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            msg.set_data(1, 0L);
            msg.set_data(2, time);
            msg.set_data(3, 0L);
            msg.set_data(4, 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, msg.pData);
        }
        finally {
            msg.dispose();
        }
    }

    public boolean processProxyModeEvent(XClientMessageEvent xclient, long sourceWindow) {
        if (xclient.get_message_type() == XDnDConstants.XA_XdndStatus.getAtom() || xclient.get_message_type() == XDnDConstants.XA_XdndFinished.getAtom()) {
            if (xclient.get_message_type() == XDnDConstants.XA_XdndFinished.getAtom()) {
                XDragSourceContextPeer.setProxyModeSourceWindow(0L);
            }
            if (xclient.get_window() == sourceWindow) {
                return false;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("        sourceWindow=" + sourceWindow + " get_window=" + xclient.get_window() + " xclient=" + xclient);
            }
            xclient.set_data(0, xclient.get_window());
            xclient.set_window(sourceWindow);
            assert (XToolkit.isAWTLockHeldByCurrentThread());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), sourceWindow, false, 0L, xclient.pData);
            return true;
        }
        return false;
    }

    public void run() {
        this.cleanup();
    }
}

