/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTKeyStroke;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XEmbedHelper {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.X11.xembed");
    static final Unsafe unsafe = Unsafe.getUnsafe();
    static final int XEMBED_VERSION = 0;
    static final int XEMBED_MAPPED = 1;
    static final int XEMBED_EMBEDDED_NOTIFY = 0;
    static final int XEMBED_WINDOW_ACTIVATE = 1;
    static final int XEMBED_WINDOW_DEACTIVATE = 2;
    static final int XEMBED_REQUEST_FOCUS = 3;
    static final int XEMBED_FOCUS_IN = 4;
    static final int XEMBED_FOCUS_OUT = 5;
    static final int XEMBED_FOCUS_NEXT = 6;
    static final int XEMBED_FOCUS_PREV = 7;
    static final int XEMBED_GRAB_KEY = 8;
    static final int XEMBED_UNGRAB_KEY = 9;
    static final int XEMBED_MODALITY_ON = 10;
    static final int XEMBED_MODALITY_OFF = 11;
    static final int XEMBED_REGISTER_ACCELERATOR = 12;
    static final int XEMBED_UNREGISTER_ACCELERATOR = 13;
    static final int XEMBED_ACTIVATE_ACCELERATOR = 14;
    static final int _SUN_XEMBED_START = 1119;
    static final int NON_STANDARD_XEMBED_GTK_GRAB_KEY = 108;
    static final int NON_STANDARD_XEMBED_GTK_UNGRAB_KEY = 109;
    static final int XEMBED_FOCUS_CURRENT = 0;
    static final int XEMBED_FOCUS_FIRST = 1;
    static final int XEMBED_FOCUS_LAST = 2;
    static final int XEMBED_MODIFIER_SHIFT = 1;
    static final int XEMBED_MODIFIER_CONTROL = 2;
    static final int XEMBED_MODIFIER_ALT = 4;
    static final int XEMBED_MODIFIER_SUPER = 8;
    static final int XEMBED_MODIFIER_HYPER = 16;
    static XAtom XEmbedInfo;
    static XAtom XEmbed;

    XEmbedHelper() {
        if (XEmbed == null) {
            XEmbed = XAtom.get("_XEMBED");
            if (xembedLog.isLoggable(Level.FINER)) {
                xembedLog.finer("Created atom " + XEmbed.toString());
            }
        }
        if (XEmbedInfo == null) {
            XEmbedInfo = XAtom.get("_XEMBED_INFO");
            if (xembedLog.isLoggable(Level.FINER)) {
                xembedLog.finer("Created atom " + XEmbedInfo.toString());
            }
        }
    }

    void sendMessage(long window, int message) {
        this.sendMessage(window, message, 0L, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(long window, int message, long detail, long data1, long data2) {
        XClientMessageEvent msg = new XClientMessageEvent();
        msg.set_type(33);
        msg.set_window(window);
        msg.set_message_type(XEmbed.getAtom());
        msg.set_format(32);
        msg.set_data(0, XToolkit.getCurrentServerTime());
        msg.set_data(1, message);
        msg.set_data(2, detail);
        msg.set_data(3, data1);
        msg.set_data(4, data2);
        XToolkit.awtLock();
        try {
            if (xembedLog.isLoggable(Level.FINE)) {
                xembedLog.fine("Sending " + XEmbedHelper.XEmbedMessageToString(msg));
            }
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), window, false, 0L, msg.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
        msg.dispose();
    }

    static String msgidToString(int msg_id) {
        switch (msg_id) {
            case 0: {
                return "XEMBED_EMBEDDED_NOTIFY";
            }
            case 1: {
                return "XEMBED_WINDOW_ACTIVATE";
            }
            case 2: {
                return "XEMBED_WINDOW_DEACTIVATE";
            }
            case 4: {
                return "XEMBED_FOCUS_IN";
            }
            case 5: {
                return "XEMBED_FOCUS_OUT";
            }
            case 3: {
                return "XEMBED_REQUEST_FOCUS";
            }
            case 6: {
                return "XEMBED_FOCUS_NEXT";
            }
            case 7: {
                return "XEMBED_FOCUS_PREV";
            }
            case 10: {
                return "XEMBED_MODALITY_ON";
            }
            case 11: {
                return "XEMBED_MODALITY_OFF";
            }
            case 12: {
                return "XEMBED_REGISTER_ACCELERATOR";
            }
            case 13: {
                return "XEMBED_UNREGISTER_ACCELERATOR";
            }
            case 14: {
                return "XEMBED_ACTIVATE_ACCELERATOR";
            }
            case 8: {
                return "XEMBED_GRAB_KEY";
            }
            case 9: {
                return "XEMBED_UNGRAB_KEY";
            }
            case 109: {
                return "NON_STANDARD_XEMBED_GTK_UNGRAB_KEY";
            }
            case 108: {
                return "NON_STANDARD_XEMBED_GTK_GRAB_KEY";
            }
            case 1119: {
                return "XEMBED_START";
            }
            case 32770: {
                return "KeyPress";
            }
            case 32787: {
                return "MapNotify";
            }
            case 32796: {
                return "PropertyNotify";
            }
        }
        return "unknown XEMBED id " + msg_id;
    }

    static String focusIdToString(int focus_id) {
        switch (focus_id) {
            case 0: {
                return "XEMBED_FOCUS_CURRENT";
            }
            case 1: {
                return "XEMBED_FOCUS_FIRST";
            }
            case 2: {
                return "XEMBED_FOCUS_LAST";
            }
        }
        return "unknown focus id " + focus_id;
    }

    static String XEmbedMessageToString(XClientMessageEvent msg) {
        return "XEmbed message to " + Long.toHexString(msg.get_window()) + ": " + XEmbedHelper.msgidToString((int)msg.get_data(1)) + ", detail: " + msg.get_data(2) + ", data:[" + msg.get_data(3) + "," + msg.get_data(4) + "]";
    }

    int getModifiers(int state) {
        int mods = 0;
        if ((state & 1) != 0) {
            mods |= 0x40;
        }
        if ((state & 2) != 0) {
            mods |= 0x80;
        }
        if ((state & 4) != 0) {
            mods |= 0x200;
        }
        if ((state & 8) != 0) {
            mods |= 0x200;
        }
        return mods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AWTKeyStroke getKeyStrokeForKeySym(long keysym, long state) {
        int keycode;
        XBaseWindow.checkSecurity();
        XToolkit.awtLock();
        try {
            keycode = XWindow.getAWTKeyCodeForKeySym((int)keysym);
        }
        finally {
            XToolkit.awtUnlock();
        }
        int modifiers = this.getModifiers((int)state);
        return AWTKeyStroke.getAWTKeyStroke(keycode, modifiers);
    }
}

