/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.font.FileFontStrike;
import sun.font.FontManager;
import sun.font.FontScaler;
import sun.font.FontScalerException;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.StrikeMetrics;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public abstract class FileFont
extends PhysicalFont {
    protected boolean useJavaRasterizer = true;
    protected int fileSize;
    protected FontScaler scaler;
    protected boolean checkedNatives;
    protected boolean useNatives;
    protected NativeFont[] nativeFonts;
    protected char[] glyphToCharMap;

    FileFont(String platname, Object nativeNames) throws FontFormatException {
        super(platname, nativeNames);
    }

    FontStrike createStrike(FontStrikeDesc desc) {
        if (!this.checkedNatives) {
            this.checkUseNatives();
        }
        return new FileFontStrike(this, desc);
    }

    protected boolean checkUseNatives() {
        this.checkedNatives = true;
        return this.useNatives;
    }

    protected abstract void close();

    abstract ByteBuffer readBlock(int var1, int var2);

    public boolean canDoStyle(int style) {
        return true;
    }

    void setFileToRemove(File file) {
        Disposer.addObjectRecord(this, new CreatedFontFileDisposerRecord(file));
    }

    synchronized void deregisterFontAndClearStrikeCache() {
        FontManager.deRegisterBadFont(this);
        for (Reference strikeRef : this.strikeCache.values()) {
            FileFontStrike strike;
            if (strikeRef == null || (strike = (FileFontStrike)strikeRef.get()) == null || strike.pScalerContext == 0L) continue;
            this.scaler.invalidateScalerContext(strike.pScalerContext);
        }
        this.scaler.dispose();
        this.scaler = FontManager.getNullScaler();
    }

    StrikeMetrics getFontMetrics(long pScalerContext) {
        try {
            return this.getScaler().getFontMetrics(pScalerContext);
        }
        catch (FontScalerException fe) {
            this.scaler = FontManager.getNullScaler();
            return this.getFontMetrics(pScalerContext);
        }
    }

    float getGlyphAdvance(long pScalerContext, int glyphCode) {
        try {
            return this.getScaler().getGlyphAdvance(pScalerContext, glyphCode);
        }
        catch (FontScalerException fe) {
            this.scaler = FontManager.getNullScaler();
            return this.getGlyphAdvance(pScalerContext, glyphCode);
        }
    }

    void getGlyphMetrics(long pScalerContext, int glyphCode, Point2D.Float metrics) {
        try {
            this.getScaler().getGlyphMetrics(pScalerContext, glyphCode, metrics);
        }
        catch (FontScalerException fe) {
            this.scaler = FontManager.getNullScaler();
            this.getGlyphMetrics(pScalerContext, glyphCode, metrics);
        }
    }

    long getGlyphImage(long pScalerContext, int glyphCode) {
        try {
            return this.getScaler().getGlyphImage(pScalerContext, glyphCode);
        }
        catch (FontScalerException fe) {
            this.scaler = FontManager.getNullScaler();
            return this.getGlyphImage(pScalerContext, glyphCode);
        }
    }

    Rectangle2D.Float getGlyphOutlineBounds(long pScalerContext, int glyphCode) {
        try {
            return this.getScaler().getGlyphOutlineBounds(pScalerContext, glyphCode);
        }
        catch (FontScalerException fe) {
            this.scaler = FontManager.getNullScaler();
            return this.getGlyphOutlineBounds(pScalerContext, glyphCode);
        }
    }

    GeneralPath getGlyphOutline(long pScalerContext, int glyphCode, float x, float y) {
        try {
            return this.getScaler().getGlyphOutline(pScalerContext, glyphCode, x, y);
        }
        catch (FontScalerException fe) {
            this.scaler = FontManager.getNullScaler();
            return this.getGlyphOutline(pScalerContext, glyphCode, x, y);
        }
    }

    GeneralPath getGlyphVectorOutline(long pScalerContext, int[] glyphs, int numGlyphs, float x, float y) {
        try {
            return this.getScaler().getGlyphVectorOutline(pScalerContext, glyphs, numGlyphs, x, y);
        }
        catch (FontScalerException fe) {
            this.scaler = FontManager.getNullScaler();
            return this.getGlyphVectorOutline(pScalerContext, glyphs, numGlyphs, x, y);
        }
    }

    protected abstract FontScaler getScaler();

    protected long getUnitsPerEm() {
        return this.getScaler().getUnitsPerEm();
    }

    private static class CreatedFontFileDisposerRecord
    implements DisposerRecord {
        File fontFile = null;

        private CreatedFontFileDisposerRecord(File file) {
            this.fontFile = file;
        }

        public void dispose() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (CreatedFontFileDisposerRecord.this.fontFile != null) {
                        try {
                            CreatedFontFileDisposerRecord.this.fontFile.delete();
                            FontManager.tmpFontFiles.remove(CreatedFontFileDisposerRecord.this.fontFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
    }
}

