/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.spec.DESKeySpec;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.CksumType;
import sun.security.krb5.internal.crypto.Des;

public final class RsaMd5DesCksumType
extends CksumType {
    public int confounderSize() {
        return 8;
    }

    public int cksumType() {
        return 8;
    }

    public boolean isSafe() {
        return true;
    }

    public int cksumSize() {
        return 24;
    }

    public int keyType() {
        return 1;
    }

    public int keySize() {
        return 8;
    }

    public byte[] calculateKeyedChecksum(byte[] data, int size, byte[] key, int usage) throws KrbCryptoException {
        byte[] new_data = new byte[size + this.confounderSize()];
        byte[] conf = Confounder.bytes(this.confounderSize());
        System.arraycopy(conf, 0, new_data, 0, this.confounderSize());
        System.arraycopy(data, 0, new_data, this.confounderSize(), size);
        byte[] mdc_cksum = this.calculateChecksum(new_data, new_data.length);
        byte[] cksum = new byte[this.cksumSize()];
        System.arraycopy(conf, 0, cksum, 0, this.confounderSize());
        System.arraycopy(mdc_cksum, 0, cksum, this.confounderSize(), this.cksumSize() - this.confounderSize());
        byte[] new_key = new byte[this.keySize()];
        System.arraycopy(key, 0, new_key, 0, key.length);
        for (int i = 0; i < new_key.length; ++i) {
            new_key[i] = (byte)(new_key[i] ^ 0xF0);
        }
        try {
            if (DESKeySpec.isWeak(new_key, 0)) {
                new_key[7] = (byte)(new_key[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException ex) {
            // empty catch block
        }
        byte[] ivec = new byte[new_key.length];
        byte[] enc_cksum = new byte[cksum.length];
        Des.cbc_encrypt(cksum, enc_cksum, new_key, ivec, true);
        return enc_cksum;
    }

    public boolean verifyKeyedChecksum(byte[] data, int size, byte[] key, byte[] checksum, int usage) throws KrbCryptoException {
        byte[] cksum = this.decryptKeyedChecksum(checksum, key);
        byte[] new_data = new byte[size + this.confounderSize()];
        System.arraycopy(cksum, 0, new_data, 0, this.confounderSize());
        System.arraycopy(data, 0, new_data, this.confounderSize(), size);
        byte[] new_cksum = this.calculateChecksum(new_data, new_data.length);
        byte[] orig_cksum = new byte[this.cksumSize() - this.confounderSize()];
        System.arraycopy(cksum, this.confounderSize(), orig_cksum, 0, this.cksumSize() - this.confounderSize());
        return RsaMd5DesCksumType.isChecksumEqual(orig_cksum, new_cksum);
    }

    private byte[] decryptKeyedChecksum(byte[] enc_cksum, byte[] key) throws KrbCryptoException {
        byte[] new_key = new byte[this.keySize()];
        System.arraycopy(key, 0, new_key, 0, key.length);
        for (int i = 0; i < new_key.length; ++i) {
            new_key[i] = (byte)(new_key[i] ^ 0xF0);
        }
        try {
            if (DESKeySpec.isWeak(new_key, 0)) {
                new_key[7] = (byte)(new_key[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException ex) {
            // empty catch block
        }
        byte[] ivec = new byte[new_key.length];
        byte[] cksum = new byte[enc_cksum.length];
        Des.cbc_encrypt(enc_cksum, cksum, new_key, ivec, false);
        return cksum;
    }

    public byte[] calculateChecksum(byte[] data, int size) throws KrbCryptoException {
        MessageDigest md5;
        byte[] result = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new KrbCryptoException("JCE provider may not be installed. " + e.getMessage());
        }
        try {
            md5.update(data);
            result = md5.digest();
        }
        catch (Exception e) {
            throw new KrbCryptoException(e.getMessage());
        }
        return result;
    }
}

