/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.DistributionPointFetcher;
import sun.security.provider.certpath.URICertStore;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLEntryImpl;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CrlRevocationChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private final TrustAnchor mAnchor;
    private final List<CertStore> mStores;
    private final String mSigProvider;
    private final Date mCurrentTime;
    private PublicKey mPrevPubKey;
    private boolean mCRLSignFlag;
    private HashSet<X509CRL> mPossibleCRLs;
    private HashSet<X509CRL> mApprovedCRLs;
    private final PKIXParameters mParams;
    private static final boolean[] mCrlSignUsage = new boolean[]{false, false, false, false, false, false, true};
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};

    CrlRevocationChecker(TrustAnchor anchor, PKIXParameters params) throws CertPathValidatorException {
        this(anchor, params, null);
    }

    CrlRevocationChecker(TrustAnchor anchor, PKIXParameters params, Collection<X509Certificate> certs) throws CertPathValidatorException {
        Date testDate;
        block3: {
            this.mAnchor = anchor;
            this.mParams = params;
            this.mStores = new ArrayList<CertStore>(params.getCertStores());
            this.mSigProvider = params.getSigProvider();
            if (certs != null) {
                try {
                    this.mStores.add(CertStore.getInstance("Collection", new CollectionCertStoreParameters(certs)));
                }
                catch (Exception e) {
                    if (debug == null) break block3;
                    debug.println("CrlRevocationChecker: error creating Collection CertStore: " + e);
                }
            }
        }
        this.mCurrentTime = (testDate = params.getDate()) != null ? testDate : new Date();
        this.init(false);
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (!forward) {
            this.mPrevPubKey = this.mAnchor != null ? (this.mAnchor.getCAPublicKey() != null ? this.mAnchor.getCAPublicKey() : this.mAnchor.getTrustedCert().getPublicKey()) : null;
        } else {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.mCRLSignFlag = true;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        X509Certificate currCert = (X509Certificate)cert;
        this.verifyRevocationStatus(currCert, this.mPrevPubKey, this.mCRLSignFlag, true);
        PublicKey cKey = currCert.getPublicKey();
        if (cKey instanceof DSAPublicKey && ((DSAPublicKey)cKey).getParams() == null) {
            cKey = BasicChecker.makeInheritedParamsKey(cKey, this.mPrevPubKey);
        }
        this.mPrevPubKey = cKey;
        this.mCRLSignFlag = CrlRevocationChecker.certCanSignCrl(currCert);
    }

    public boolean check(X509Certificate currCert, PublicKey prevKey, boolean signFlag) throws CertPathValidatorException {
        this.verifyRevocationStatus(currCert, prevKey, signFlag, true);
        return CrlRevocationChecker.certCanSignCrl(currCert);
    }

    static boolean certCanSignCrl(X509Certificate currCert) {
        boolean[] kbools = currCert.getKeyUsage();
        if (kbools != null) {
            return kbools[6];
        }
        return false;
    }

    private void verifyRevocationStatus(X509Certificate currCert, PublicKey prevKey, boolean signFlag, boolean allowSeparateKey) throws CertPathValidatorException {
        this.verifyRevocationStatus(currCert, prevKey, signFlag, allowSeparateKey, null);
    }

    private void verifyRevocationStatus(X509Certificate currCert, PublicKey prevKey, boolean signFlag, boolean allowSeparateKey, Set<X509Certificate> stackedCerts) throws CertPathValidatorException {
        String msg = "revocation status";
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() ---checking " + msg + "...");
        }
        if (stackedCerts != null && stackedCerts.contains(currCert)) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus() circular dependency");
            }
            throw new CertPathValidatorException("Could not determine revocation status");
        }
        this.mPossibleCRLs = new HashSet();
        this.mApprovedCRLs = new HashSet();
        boolean[] reasonsMask = new boolean[9];
        try {
            X509CRLSelector sel = new X509CRLSelector();
            sel.setCertificateChecking(currCert);
            sel.setDateAndTime(this.mCurrentTime);
            for (CertStore mStore : this.mStores) {
                for (CRL cRL : mStore.getCRLs(sel)) {
                    this.mPossibleCRLs.add((X509CRL)cRL);
                }
            }
            DistributionPointFetcher store = DistributionPointFetcher.getInstance();
            this.mApprovedCRLs.addAll(store.getCRLs(sel, signFlag, prevKey, this.mSigProvider, this.mStores, reasonsMask, this.mAnchor));
        }
        catch (Exception e) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus() unexpected exception: " + e.getMessage());
            }
            throw new CertPathValidatorException(e);
        }
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() crls.size() = " + this.mPossibleCRLs.size());
        }
        if (!this.mPossibleCRLs.isEmpty()) {
            this.mApprovedCRLs.addAll(this.verifyPossibleCRLs(this.mPossibleCRLs, currCert, signFlag, prevKey, reasonsMask));
        }
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() approved crls.size() = " + this.mApprovedCRLs.size());
        }
        if (this.mApprovedCRLs.isEmpty() || !Arrays.equals(reasonsMask, ALL_REASONS)) {
            if (allowSeparateKey) {
                this.verifyWithSeparateSigningKey(currCert, prevKey, signFlag, stackedCerts);
                return;
            }
            throw new CertPathValidatorException("Could not determine revocation status");
        }
        if (debug != null) {
            BigInteger sn = currCert.getSerialNumber();
            debug.println("starting the final sweep...");
            debug.println("CrlRevocationChecker.verifyRevocationStatus cert SN: " + sn.toString());
        }
        int reasonCode = 0;
        X509CRLEntryImpl entry = null;
        for (X509CRL crl : this.mApprovedCRLs) {
            Set<String> unresCritExts;
            X509CRLEntry x509CRLEntry = crl.getRevokedCertificate(currCert);
            if (x509CRLEntry == null) continue;
            try {
                entry = X509CRLEntryImpl.toImpl(x509CRLEntry);
                Integer reason = entry.getReasonCode();
                reasonCode = reason == null ? 0 : reason;
            }
            catch (Exception ex) {
                throw new CertPathValidatorException(ex);
            }
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus CRL entry: " + entry.toString());
            }
            if ((unresCritExts = entry.getCriticalExtensionOIDs()) != null && !unresCritExts.isEmpty()) {
                unresCritExts.remove(PKIXExtensions.ReasonCode_Id.toString());
                unresCritExts.remove(PKIXExtensions.CertificateIssuer_Id.toString());
                if (!unresCritExts.isEmpty()) {
                    if (debug != null) {
                        debug.println("Unrecognized critical extension(s) in revoked CRL entry: " + unresCritExts);
                    }
                    throw new CertPathValidatorException("Could not determine revocation status");
                }
            }
            throw new CertificateRevokedException("Certificate has been revoked, reason: " + CrlRevocationChecker.reasonToString(reasonCode));
        }
    }

    private void verifyWithSeparateSigningKey(X509Certificate currCert, PublicKey prevKey, boolean signFlag, Set<X509Certificate> stackedCerts) throws CertPathValidatorException {
        String msg = "revocation status";
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyWithSeparateSigningKey() ---checking " + msg + "...");
        }
        if (stackedCerts != null && stackedCerts.contains(currCert)) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyWithSeparateSigningKey() circular dependency");
            }
            throw new CertPathValidatorException("Could not determine revocation status");
        }
        if (!signFlag) {
            prevKey = null;
        }
        this.buildToNewKey(currCert, prevKey, stackedCerts);
    }

    private void buildToNewKey(X509Certificate currCert, PublicKey prevKey, Set<X509Certificate> stackedCerts) throws CertPathValidatorException {
        PKIXBuilderParameters builderParams;
        Set<TrustAnchor> newAnchors;
        if (debug != null) {
            debug.println("CrlRevocationChecker.buildToNewKey() starting work");
        }
        HashSet<PublicKey> badKeys = new HashSet<PublicKey>();
        if (prevKey != null) {
            badKeys.add(prevKey);
        }
        RejectKeySelector certSel = new RejectKeySelector(badKeys);
        certSel.setSubject(currCert.getIssuerX500Principal());
        certSel.setKeyUsage(mCrlSignUsage);
        Set<TrustAnchor> set = newAnchors = this.mAnchor == null ? this.mParams.getTrustAnchors() : Collections.singleton(this.mAnchor);
        if (this.mParams instanceof PKIXBuilderParameters) {
            builderParams = (PKIXBuilderParameters)this.mParams.clone();
            builderParams.setTargetCertConstraints(certSel);
            builderParams.setPolicyQualifiersRejected(true);
            try {
                builderParams.setTrustAnchors(newAnchors);
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new RuntimeException(iape);
            }
        }
        try {
            builderParams = new PKIXBuilderParameters(newAnchors, (CertSelector)certSel);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException(iape);
        }
        builderParams.setInitialPolicies(this.mParams.getInitialPolicies());
        builderParams.setCertStores(this.mStores);
        builderParams.setExplicitPolicyRequired(this.mParams.isExplicitPolicyRequired());
        builderParams.setPolicyMappingInhibited(this.mParams.isPolicyMappingInhibited());
        builderParams.setAnyPolicyInhibited(this.mParams.isAnyPolicyInhibited());
        builderParams.setDate(this.mParams.getDate());
        builderParams.setCertPathCheckers(this.mParams.getCertPathCheckers());
        builderParams.setSigProvider(this.mParams.getSigProvider());
        builderParams.setRevocationEnabled(false);
        if (Builder.USE_AIA) {
            List<AccessDescription> adList;
            X509CertImpl currCertImpl;
            block32: {
                currCertImpl = null;
                try {
                    currCertImpl = X509CertImpl.toImpl(currCert);
                }
                catch (CertificateException ce) {
                    if (debug == null) break block32;
                    debug.println("CrlRevocationChecker.buildToNewKey: error decoding cert: " + ce);
                }
            }
            AuthorityInfoAccessExtension aiaExt = null;
            if (currCertImpl != null) {
                aiaExt = currCertImpl.getAuthorityInfoAccessExtension();
            }
            if (aiaExt != null && (adList = aiaExt.getAccessDescriptions()) != null) {
                for (AccessDescription ad : adList) {
                    CertStore cs = URICertStore.getInstance(ad);
                    if (cs == null) continue;
                    if (debug != null) {
                        debug.println("adding AIAext CertStore");
                    }
                    builderParams.addCertStore(cs);
                }
            }
        }
        CertPathBuilder builder = null;
        try {
            builder = CertPathBuilder.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CertPathValidatorException(nsae);
        }
        try {
            while (true) {
                if (debug != null) {
                    debug.println("CrlRevocationChecker.buildToNewKey() about to try build ...");
                }
                PKIXCertPathBuilderResult cpbr = (PKIXCertPathBuilderResult)builder.build(builderParams);
                if (debug != null) {
                    debug.println("CrlRevocationChecker.buildToNewKey() about to check revocation ...");
                }
                if (stackedCerts == null) {
                    stackedCerts = new HashSet<X509Certificate>();
                }
                stackedCerts.add(currCert);
                TrustAnchor ta = cpbr.getTrustAnchor();
                PublicKey prevKey2 = ta.getCAPublicKey();
                if (prevKey2 == null) {
                    prevKey2 = ta.getTrustedCert().getPublicKey();
                }
                boolean signFlag = true;
                List<? extends Certificate> cpList = cpbr.getCertPath().getCertificates();
                try {
                    for (int i = cpList.size() - 1; i >= 0; --i) {
                        X509Certificate cert = (X509Certificate)cpList.get(i);
                        if (debug != null) {
                            debug.println("CrlRevocationChecker.buildToNewKey() index " + i + " checking " + cert);
                        }
                        this.verifyRevocationStatus(cert, prevKey2, signFlag, true, stackedCerts);
                        signFlag = CrlRevocationChecker.certCanSignCrl(cert);
                        prevKey2 = cert.getPublicKey();
                    }
                }
                catch (CertPathValidatorException cpve) {
                    badKeys.add(cpbr.getPublicKey());
                    continue;
                }
                if (debug != null) {
                    debug.println("CrlRevocationChecker.buildToNewKey() got key " + cpbr.getPublicKey());
                }
                PublicKey newKey = cpbr.getPublicKey();
                try {
                    this.verifyRevocationStatus(currCert, newKey, true, false);
                    return;
                }
                catch (CertPathValidatorException cpve) {
                    if (cpve instanceof CertificateRevokedException) {
                        throw cpve;
                    }
                    badKeys.add(newKey);
                    continue;
                }
                break;
            }
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new CertPathValidatorException(iape);
        }
        catch (CertPathBuilderException cpbe) {
            throw new CertPathValidatorException("Could not determine revocation status", cpbe);
        }
    }

    private static String reasonToString(int reasonCode) {
        switch (reasonCode) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "key compromise";
            }
            case 2: {
                return "CA compromise";
            }
            case 3: {
                return "affiliation changed";
            }
            case 4: {
                return "superseded";
            }
            case 5: {
                return "cessation of operation";
            }
            case 6: {
                return "certificate hold";
            }
            case 8: {
                return "remove from CRL";
            }
        }
        return "unrecognized reason code";
    }

    private Collection<X509CRL> verifyPossibleCRLs(Set<X509CRL> crls, X509Certificate cert, boolean signFlag, PublicKey prevKey, boolean[] reasonsMask) throws CertPathValidatorException {
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl(cert);
            if (debug != null) {
                debug.println("CRLRevocationChecker.verifyPossibleCRLs: Checking CRLDPs for " + certImpl.getSubjectX500Principal());
            }
            CRLDistributionPointsExtension ext = certImpl.getCRLDistributionPointsExtension();
            List<DistributionPoint> points = null;
            if (ext == null) {
                X500Name certIssuer = (X500Name)certImpl.getIssuerDN();
                DistributionPoint point = new DistributionPoint(new GeneralNames().add(new GeneralName(certIssuer)), null, null);
                points = Collections.singletonList(point);
            } else {
                points = (List<DistributionPoint>)ext.get("points");
            }
            HashSet<X509CRL> results = new HashSet<X509CRL>();
            DistributionPointFetcher dpf = DistributionPointFetcher.getInstance();
            Iterator t = points.iterator();
            while (t.hasNext() && !Arrays.equals(reasonsMask, ALL_REASONS)) {
                DistributionPoint point = (DistributionPoint)t.next();
                for (X509CRL crl : crls) {
                    if (!dpf.verifyCRL(certImpl, point, crl, reasonsMask, signFlag, prevKey, this.mSigProvider, this.mAnchor, this.mStores)) continue;
                    results.add(crl);
                }
            }
            return results;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.println("Exception while verifying CRL: " + e.getMessage());
                e.printStackTrace();
            }
            return Collections.emptySet();
        }
    }

    private static class CertificateRevokedException
    extends CertPathValidatorException {
        CertificateRevokedException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RejectKeySelector
    extends X509CertSelector {
        private final Set<PublicKey> badKeySet;

        RejectKeySelector(Set<PublicKey> badPublicKeys) {
            this.badKeySet = badPublicKeys;
        }

        @Override
        public boolean match(Certificate cert) {
            if (!super.match(cert)) {
                return false;
            }
            if (this.badKeySet.contains(cert.getPublicKey())) {
                if (debug != null) {
                    debug.println("RejectCertSelector.match: bad key");
                }
                return false;
            }
            if (debug != null) {
                debug.println("RejectCertSelector.match: returning true");
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("RejectCertSelector: [\n");
            sb.append(super.toString());
            sb.append(this.badKeySet);
            sb.append("]");
            return sb.toString();
        }
    }
}

