#!/usr/bin/env python
import dsme, subprocess

class DSMEListener():
    def __init__(self, object_path):
        self.object_path = object_path
        
    def dbus_send(self, method, parameters):
        if parameters is None:
          subprocess.call(["dbus-send", "--system", self.object_path, method])
        else:
          subprocess.call(["dbus-send", "--system", self.object_path, method, parameters])
        

    def SystemState(self, state): 
        self.dbus_send("org.tspre.dsme.SystemState", "string:" + state + "")

    def DisplayState(self, state):
        self.dbus_send("org.tspre.dsme.DisplayState", "string:" + state + "")
  
    def SystemActivity(self, state):
        if state:
          what = "true"
        else:
          what = "false"
        self.dbus_send("org.tspre.dsme.SystemActivity", "boolean:" + what + "")
    
    def SaveUnsavedData(self):
        self.dbus_send("org.tspre.dsme.SaveUnsavedData", None)

    def UnknownMessage(self, type):
        self.dbus_send("org.tspre.dsme.SaveUnsavedData", "integer:" + str(type))

    
class DSMEImpl(dsme.DSME):
  def __init__(self):
    dsme.DSME.__init__(self)
    self.dbusemitter = DSMEListener("/org/tspre/dsme")
  def run(self):
      while True:
          self.read_and_parse()
 
  def in_system_state(self, state):
    self.dbusemitter.SystemState(state)

  def in_display_state(self, state):
    self.dbusemitter.DisplayState(state)

  def in_system_activity(self, state):
    self.dbusemitter.SystemActivity(state)

  def in_save_unsaved_data(self):
    self.dbusemitter.SaveUnsavedData()

  def in_unknown_type(self, type, data):
    self.dbusemitter.UnknownMessage(type)
    
if __name__ == "__main__":
  dsmeimpl = DSMEImpl()
  dsmeimpl.run()
  
