'''
Apport hook for tracker-extract crashes

tracker-extract limits its CPU/memory usage with setrlimit, which will
terminate tracker-extract if the limit is exceed. But we can't control
what signal is send and it seems to be dumping the core, so apport is
reporting the bugs to Launchpad, but this is not a bug, it's a feature!

Copyright: Emilio Pozuelo Monfort <emilio@pozuelo.org>
'''

def add_info(report):
    if report['ExecutablePath'] == '/usr/bin/tracker-extract' and \
       report['ProblemType'] == 'Crash':
        report['UnreportableReason'] = "Crashes in tracker-extract are \
intended so that tracker-extract doesn't consume many resources."
