/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.protocol.NotLocalLocalCRDImpl;
import com.sun.corba.se.impl.transport.CorbaContactInfoListIteratorImpl;
import com.sun.corba.se.impl.transport.SharedCDRContactInfoImpl;
import com.sun.corba.se.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.IIOPProfile;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
import com.sun.corba.se.spi.protocol.LocalClientRequestDispatcherFactory;
import com.sun.corba.se.spi.transport.CorbaContactInfoList;
import com.sun.corba.se.spi.transport.SocketInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CorbaContactInfoListImpl
implements CorbaContactInfoList {
    protected ORB orb;
    protected LocalClientRequestDispatcher LocalClientRequestDispatcher;
    protected IOR targetIOR;
    protected IOR effectiveTargetIOR;
    protected List effectiveTargetIORContactInfoList;
    protected ContactInfo primaryContactInfo;

    public CorbaContactInfoListImpl(ORB orb) {
        this.orb = orb;
    }

    public CorbaContactInfoListImpl(ORB orb, IOR targetIOR) {
        this(orb);
        this.setTargetIOR(targetIOR);
    }

    public synchronized Iterator iterator() {
        this.createContactInfoList();
        return new CorbaContactInfoListIteratorImpl(this.orb, this, this.primaryContactInfo, this.effectiveTargetIORContactInfoList);
    }

    public synchronized void setTargetIOR(IOR targetIOR) {
        this.targetIOR = targetIOR;
        this.setEffectiveTargetIOR(targetIOR);
    }

    public synchronized IOR getTargetIOR() {
        return this.targetIOR;
    }

    public synchronized void setEffectiveTargetIOR(IOR effectiveTargetIOR) {
        this.effectiveTargetIOR = effectiveTargetIOR;
        this.effectiveTargetIORContactInfoList = null;
        if (this.primaryContactInfo != null && this.orb.getORBData().getIIOPPrimaryToContactInfo() != null) {
            this.orb.getORBData().getIIOPPrimaryToContactInfo().reset(this.primaryContactInfo);
        }
        this.primaryContactInfo = null;
        this.setLocalSubcontract();
    }

    public synchronized IOR getEffectiveTargetIOR() {
        return this.effectiveTargetIOR;
    }

    public synchronized LocalClientRequestDispatcher getLocalClientRequestDispatcher() {
        return this.LocalClientRequestDispatcher;
    }

    public synchronized int hashCode() {
        return this.targetIOR.hashCode();
    }

    protected void createContactInfoList() {
        if (this.effectiveTargetIORContactInfoList != null) {
            return;
        }
        this.effectiveTargetIORContactInfoList = new ArrayList();
        IIOPProfile iiopProfile = this.effectiveTargetIOR.getProfile();
        String hostname = ((IIOPProfileTemplate)iiopProfile.getTaggedProfileTemplate()).getPrimaryAddress().getHost().toLowerCase();
        int port = ((IIOPProfileTemplate)iiopProfile.getTaggedProfileTemplate()).getPrimaryAddress().getPort();
        this.primaryContactInfo = this.createContactInfo("IIOP_CLEAR_TEXT", hostname, port);
        if (iiopProfile.isLocal()) {
            SharedCDRContactInfoImpl contactInfo = new SharedCDRContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition());
            this.effectiveTargetIORContactInfoList.add(contactInfo);
        } else {
            this.addRemoteContactInfos(this.effectiveTargetIOR, this.effectiveTargetIORContactInfoList);
        }
    }

    protected void addRemoteContactInfos(IOR effectiveTargetIOR, List effectiveTargetIORContactInfoList) {
        List socketInfos = this.orb.getORBData().getIORToSocketInfo().getSocketInfo(effectiveTargetIOR);
        for (SocketInfo socketInfo : socketInfos) {
            String type = socketInfo.getType();
            String host = socketInfo.getHost().toLowerCase();
            int port = socketInfo.getPort();
            ContactInfo contactInfo = this.createContactInfo(type, host, port);
            effectiveTargetIORContactInfoList.add(contactInfo);
        }
    }

    protected ContactInfo createContactInfo(String type, String hostname, int port) {
        return new SocketOrChannelContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition(), type, hostname, port);
    }

    protected void setLocalSubcontract() {
        if (!this.effectiveTargetIOR.getProfile().isLocal()) {
            this.LocalClientRequestDispatcher = new NotLocalLocalCRDImpl();
            return;
        }
        int scid = this.effectiveTargetIOR.getProfile().getObjectKeyTemplate().getSubcontractId();
        LocalClientRequestDispatcherFactory lcsf = this.orb.getRequestDispatcherRegistry().getLocalClientRequestDispatcherFactory(scid);
        this.LocalClientRequestDispatcher = lcsf.create(scid, this.effectiveTargetIOR);
    }
}

