/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.orb;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBClassLoader;
import com.sun.corba.se.impl.orbutil.ObjectUtility;
import com.sun.corba.se.spi.orb.Operation;
import com.sun.corba.se.spi.orb.StringPair;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public abstract class OperationFactory {
    private static Operation suffixActionImpl = new SuffixAction();
    private static Operation valueActionImpl = new ValueAction();
    private static Operation identityActionImpl = new IdentityAction();
    private static Operation booleanActionImpl = new BooleanAction();
    private static Operation integerActionImpl = new IntegerAction();
    private static Operation stringActionImpl = new StringAction();
    private static Operation classActionImpl = new ClassAction();
    private static Operation setFlagActionImpl = new SetFlagAction();
    private static Operation URLActionImpl = new URLAction();
    private static Operation convertIntegerToShortImpl = new ConvertIntegerToShort();

    private OperationFactory() {
    }

    private static String getString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new Error("String expected");
    }

    private static Object[] getObjectArray(Object obj) {
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        throw new Error("Object[] expected");
    }

    private static StringPair getStringPair(Object obj) {
        if (obj instanceof StringPair) {
            return (StringPair)obj;
        }
        throw new Error("StringPair expected");
    }

    public static Operation maskErrorAction(Operation op) {
        return new MaskErrorAction(op);
    }

    public static Operation indexAction(int index) {
        return new IndexAction(index);
    }

    public static Operation identityAction() {
        return identityActionImpl;
    }

    public static Operation suffixAction() {
        return suffixActionImpl;
    }

    public static Operation valueAction() {
        return valueActionImpl;
    }

    public static Operation booleanAction() {
        return booleanActionImpl;
    }

    public static Operation integerAction() {
        return integerActionImpl;
    }

    public static Operation stringAction() {
        return stringActionImpl;
    }

    public static Operation classAction() {
        return classActionImpl;
    }

    public static Operation setFlagAction() {
        return setFlagActionImpl;
    }

    public static Operation URLAction() {
        return URLActionImpl;
    }

    public static Operation integerRangeAction(int min, int max) {
        return new IntegerRangeAction(min, max);
    }

    public static Operation listAction(String sep, Operation act) {
        return new ListAction(sep, act);
    }

    public static Operation sequenceAction(String sep, Operation[] actions2) {
        return new SequenceAction(sep, actions2);
    }

    public static Operation compose(Operation op1, Operation op2) {
        return new ComposeAction(op1, op2);
    }

    public static Operation mapAction(Operation op) {
        return new MapAction(op);
    }

    public static Operation mapSequenceAction(Operation[] op) {
        return new MapSequenceAction(op);
    }

    public static Operation convertIntegerToShort() {
        return convertIntegerToShortImpl;
    }

    private static class ConvertIntegerToShort
    extends OperationBase {
        private ConvertIntegerToShort() {
        }

        public Object operate(Object value) {
            Integer val = (Integer)value;
            return new Short(val.shortValue());
        }

        public String toString() {
            return "ConvertIntegerToShort";
        }
    }

    private static class MapSequenceAction
    extends OperationBase {
        private Operation[] op;

        public MapSequenceAction(Operation[] op) {
            this.op = op;
        }

        public Object operate(Object value) {
            Object[] values = (Object[])value;
            Object[] result = new Object[values.length];
            for (int ctr = 0; ctr < values.length; ++ctr) {
                result[ctr] = this.op[ctr].operate(values[ctr]);
            }
            return result;
        }

        public String toString() {
            return "mapSequenceAction(" + ObjectUtility.compactObjectToString(this.op) + ")";
        }
    }

    private static class MapAction
    extends OperationBase {
        Operation op;

        MapAction(Operation op) {
            this.op = op;
        }

        public Object operate(Object value) {
            Object[] values = (Object[])value;
            Object[] result = new Object[values.length];
            for (int ctr = 0; ctr < values.length; ++ctr) {
                result[ctr] = this.op.operate(values[ctr]);
            }
            return result;
        }

        public String toString() {
            return "mapAction(" + this.op + ")";
        }
    }

    private static class ComposeAction
    extends OperationBase {
        private Operation op1;
        private Operation op2;

        ComposeAction(Operation op1, Operation op2) {
            this.op1 = op1;
            this.op2 = op2;
        }

        public Object operate(Object value) {
            return this.op2.operate(this.op1.operate(value));
        }

        public String toString() {
            return "composition(" + this.op1 + "," + this.op2 + ")";
        }
    }

    private static class SequenceAction
    extends OperationBase {
        private String sep;
        private Operation[] actions;

        SequenceAction(String sep, Operation[] actions2) {
            this.sep = sep;
            this.actions = actions2;
        }

        public Object operate(Object value) {
            StringTokenizer st = new StringTokenizer(OperationFactory.getString(value), this.sep);
            int numTokens = st.countTokens();
            if (numTokens != this.actions.length) {
                throw new Error("Number of tokens and number of actions do not match");
            }
            int ctr = 0;
            Object[] result = new Object[numTokens];
            while (st.hasMoreTokens()) {
                Operation act = this.actions[ctr];
                String next = st.nextToken();
                result[ctr++] = act.operate(next);
            }
            return result;
        }

        public String toString() {
            return "sequenceAction(separator=\"" + this.sep + "\",actions=" + ObjectUtility.compactObjectToString(this.actions) + ")";
        }
    }

    private static class ListAction
    extends OperationBase {
        private String sep;
        private Operation act;

        ListAction(String sep, Operation act) {
            this.sep = sep;
            this.act = act;
        }

        public Object operate(Object value) {
            StringTokenizer st = new StringTokenizer(OperationFactory.getString(value), this.sep);
            int length = st.countTokens();
            Object result = null;
            int ctr = 0;
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                Object val = this.act.operate(next);
                if (result == null) {
                    result = Array.newInstance(val.getClass(), length);
                }
                Array.set(result, ctr++, val);
            }
            return result;
        }

        public String toString() {
            return "listAction(separator=\"" + this.sep + "\",action=" + this.act + ")";
        }
    }

    private static class IntegerRangeAction
    extends OperationBase {
        private int min;
        private int max;

        IntegerRangeAction(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public Object operate(Object value) {
            int result = Integer.parseInt(OperationFactory.getString(value));
            if (result >= this.min && result <= this.max) {
                return new Integer(result);
            }
            throw new IllegalArgumentException("Property value " + result + " is not in the range " + this.min + " to " + this.max);
        }

        public String toString() {
            return "integerRangeAction(" + this.min + "," + this.max + ")";
        }
    }

    private static class URLAction
    extends OperationBase {
        private URLAction() {
        }

        public Object operate(Object value) {
            String val = (String)value;
            try {
                return new URL(val);
            }
            catch (MalformedURLException exc) {
                ORBUtilSystemException wrapper = ORBUtilSystemException.get("orb.lifecycle");
                throw wrapper.badUrl(exc, (Object)val);
            }
        }

        public String toString() {
            return "URLAction";
        }
    }

    private static class SetFlagAction
    extends OperationBase {
        private SetFlagAction() {
        }

        public Object operate(Object value) {
            return Boolean.TRUE;
        }

        public String toString() {
            return "setFlagAction";
        }
    }

    private static class ClassAction
    extends OperationBase {
        private ClassAction() {
        }

        public Object operate(Object value) {
            String className = OperationFactory.getString(value);
            try {
                Class result = ORBClassLoader.loadClass(className);
                return result;
            }
            catch (Exception exc) {
                ORBUtilSystemException wrapper = ORBUtilSystemException.get("orb.lifecycle");
                throw wrapper.couldNotLoadClass(exc, (Object)className);
            }
        }

        public String toString() {
            return "classAction";
        }
    }

    private static class StringAction
    extends OperationBase {
        private StringAction() {
        }

        public Object operate(Object value) {
            return value;
        }

        public String toString() {
            return "stringAction";
        }
    }

    private static class IntegerAction
    extends OperationBase {
        private IntegerAction() {
        }

        public Object operate(Object value) {
            return new Integer(OperationFactory.getString(value));
        }

        public String toString() {
            return "integerAction";
        }
    }

    private static class BooleanAction
    extends OperationBase {
        private BooleanAction() {
        }

        public Object operate(Object value) {
            return new Boolean(OperationFactory.getString(value));
        }

        public String toString() {
            return "booleanAction";
        }
    }

    private static class IdentityAction
    extends OperationBase {
        private IdentityAction() {
        }

        public Object operate(Object value) {
            return value;
        }

        public String toString() {
            return "identityAction";
        }
    }

    private static class ValueAction
    extends OperationBase {
        private ValueAction() {
        }

        public Object operate(Object value) {
            return OperationFactory.getStringPair(value).getSecond();
        }

        public String toString() {
            return "valueAction";
        }
    }

    private static class SuffixAction
    extends OperationBase {
        private SuffixAction() {
        }

        public Object operate(Object value) {
            return OperationFactory.getStringPair(value).getFirst();
        }

        public String toString() {
            return "suffixAction";
        }
    }

    private static class IndexAction
    extends OperationBase {
        private int index;

        public IndexAction(int index) {
            this.index = index;
        }

        public Object operate(Object value) {
            return OperationFactory.getObjectArray(value)[this.index];
        }

        public String toString() {
            return "indexAction(" + this.index + ")";
        }
    }

    private static class MaskErrorAction
    extends OperationBase {
        private Operation op;

        public MaskErrorAction(Operation op) {
            this.op = op;
        }

        public Object operate(Object arg) {
            try {
                return this.op.operate(arg);
            }
            catch (Exception exc) {
                return null;
            }
        }

        public String toString() {
            return "maskErrorAction(" + this.op + ")";
        }
    }

    private static abstract class OperationBase
    implements Operation {
        private OperationBase() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OperationBase)) {
                return false;
            }
            OperationBase other = (OperationBase)obj;
            return this.toString().equals(other.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

