/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;

public class SnmpIpAddress
extends SnmpOid {
    private static final long serialVersionUID = 7204629998270874474L;
    static final String name = "IpAddress";

    public SnmpIpAddress(byte[] bytes) throws IllegalArgumentException {
        this.buildFromByteArray(bytes);
    }

    public SnmpIpAddress(long addr) {
        int address = (int)addr;
        byte[] ipaddr = new byte[]{(byte)(address >>> 24 & 0xFF), (byte)(address >>> 16 & 0xFF), (byte)(address >>> 8 & 0xFF), (byte)(address & 0xFF)};
        this.buildFromByteArray(ipaddr);
    }

    public SnmpIpAddress(String dotAddress) throws IllegalArgumentException {
        super(dotAddress);
        if (this.componentCount > 4 || this.components[0] > 255L || this.components[1] > 255L || this.components[2] > 255L || this.components[3] > 255L) {
            throw new IllegalArgumentException(dotAddress);
        }
    }

    public SnmpIpAddress(long b1, long b2, long b3, long b4) {
        super(b1, b2, b3, b4);
        if (this.components[0] > 255L || this.components[1] > 255L || this.components[2] > 255L || this.components[3] > 255L) {
            throw new IllegalArgumentException();
        }
    }

    public byte[] byteValue() {
        byte[] result = new byte[]{(byte)this.components[0], (byte)this.components[1], (byte)this.components[2], (byte)this.components[3]};
        return result;
    }

    public String stringValue() {
        return this.toString();
    }

    public static SnmpOid toOid(long[] index, int start) throws SnmpStatusException {
        if (start + 4 <= index.length) {
            try {
                return new SnmpOid(index[start], index[start + 1], index[start + 2], index[start + 3]);
            }
            catch (IllegalArgumentException e) {
                throw new SnmpStatusException(2);
            }
        }
        throw new SnmpStatusException(2);
    }

    public static int nextOid(long[] index, int start) throws SnmpStatusException {
        if (start + 4 <= index.length) {
            return start + 4;
        }
        throw new SnmpStatusException(2);
    }

    public static void appendToOid(SnmpOid source, SnmpOid dest) {
        if (source.getLength() != 4) {
            throw new IllegalArgumentException();
        }
        dest.append(source);
    }

    public final String getTypeName() {
        return name;
    }

    private void buildFromByteArray(byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException();
        }
        this.components = new long[4];
        this.componentCount = 4;
        this.components[0] = bytes[0] >= 0 ? (long)bytes[0] : (long)(bytes[0] + 256);
        this.components[1] = bytes[1] >= 0 ? (long)bytes[1] : (long)(bytes[1] + 256);
        this.components[2] = bytes[2] >= 0 ? (long)bytes[2] : (long)(bytes[2] + 256);
        this.components[3] = bytes[3] >= 0 ? (long)bytes[3] : (long)(bytes[3] + 256);
    }
}

