/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpUnknownModelException;
import com.sun.jmx.snmp.agent.LongList;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.internal.SnmpAccessControlModel;
import com.sun.jmx.snmp.internal.SnmpEngineImpl;
import java.util.logging.Level;

class AcmChecker {
    SnmpAccessControlModel model;
    String principal;
    int securityLevel;
    int version;
    int pduType;
    int securityModel;
    byte[] contextName;
    SnmpEngineImpl engine;
    LongList l;

    AcmChecker(SnmpMibRequest req) {
        block5: {
            this.model = null;
            this.principal = null;
            this.securityLevel = -1;
            this.version = -1;
            this.pduType = -1;
            this.securityModel = -1;
            this.contextName = null;
            this.engine = null;
            this.l = null;
            this.engine = (SnmpEngineImpl)req.getEngine();
            if (this.engine != null && this.engine.isCheckOidActivated()) {
                try {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "AcmChecker(SnmpMibRequest)", "SNMP V3 Access Control to be done");
                    }
                    this.model = (SnmpAccessControlModel)this.engine.getAccessControlSubSystem().getModel(4430);
                    this.principal = req.getPrincipal();
                    this.securityLevel = req.getSecurityLevel();
                    this.pduType = req.getPdu().type;
                    this.version = req.getRequestPduVersion();
                    this.securityModel = req.getSecurityModel();
                    this.contextName = req.getAccessContextName();
                    this.l = new LongList();
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        StringBuilder strb = new StringBuilder().append("Will check oid for : principal : ").append(this.principal).append("; securityLevel : ").append(this.securityLevel).append("; pduType : ").append(this.pduType).append("; version : ").append(this.version).append("; securityModel : ").append(this.securityModel).append("; contextName : ").append(this.contextName);
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "AcmChecker(SnmpMibRequest)", strb.toString());
                    }
                }
                catch (SnmpUnknownModelException e) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block5;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "AcmChecker(SnmpMibRequest)", "Unknown Model, no ACM check.");
                }
            }
        }
    }

    void add(int index, long arc) {
        if (this.model != null) {
            this.l.add(index, arc);
        }
    }

    void remove(int index) {
        if (this.model != null) {
            this.l.remove(index);
        }
    }

    void add(int at, long[] src, int from, int count) {
        if (this.model != null) {
            this.l.add(at, src, from, count);
        }
    }

    void remove(int from, int count) {
        if (this.model != null) {
            this.l.remove(from, count);
        }
    }

    void checkCurrentOid() throws SnmpStatusException {
        if (this.model != null) {
            SnmpOid oid = new SnmpOid(this.l.toArray());
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "checkCurrentOid", "Checking access for : " + oid);
            }
            this.model.checkAccess(this.version, this.principal, this.securityLevel, this.pduType, this.securityModel, this.contextName, oid);
        }
    }
}

