/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation;

import com.sun.org.apache.xerces.internal.jaxp.validation.JAXPValidationMessageFormatter;
import com.sun.org.apache.xerces.internal.jaxp.validation.ValidatorHandlerImpl;
import com.sun.org.apache.xerces.internal.jaxp.validation.ValidatorHelper;
import com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaValidatorComponentManager;
import java.io.IOException;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import org.xml.sax.SAXException;

public final class StAXValidatorHelper
implements ValidatorHelper {
    private XMLSchemaValidatorComponentManager fComponentManager;
    private Transformer identityTransformer1 = null;
    private TransformerHandler identityTransformer2 = null;
    private ValidatorHandlerImpl handler = null;

    public StAXValidatorHelper(XMLSchemaValidatorComponentManager componentManager) {
        this.fComponentManager = componentManager;
    }

    public void validate(Source source, Result result) throws SAXException, IOException {
        if (result == null || result instanceof StAXResult) {
            if (this.identityTransformer1 == null) {
                try {
                    SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                    this.identityTransformer1 = tf.newTransformer();
                    this.identityTransformer2 = tf.newTransformerHandler();
                }
                catch (TransformerConfigurationException e) {
                    throw new TransformerFactoryConfigurationError(e);
                }
            }
            if (result != null) {
                this.handler = new ValidatorHandlerImpl(this.fComponentManager);
                this.handler.setContentHandler(this.identityTransformer2);
                this.identityTransformer2.setResult(result);
            }
            try {
                this.identityTransformer1.transform(source, new SAXResult(this.handler));
            }
            catch (TransformerException e) {
                if (e.getException() instanceof SAXException) {
                    throw (SAXException)e.getException();
                }
                throw new SAXException(e);
            }
            finally {
                this.handler.setContentHandler(null);
            }
            return;
        }
        throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "SourceResultMismatch", new Object[]{source.getClass().getName(), result.getClass().getName()}));
    }
}

