/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sun.security.util.DerValue;

public class XMLX509SKI
extends SignatureElementProxy
implements XMLX509DataContent {
    static Logger log = Logger.getLogger(XMLX509SKI.class.getName());
    public static final String SKI_OID = "2.5.29.14";

    public XMLX509SKI(Document doc, byte[] skiBytes) {
        super(doc);
        this.addBase64Text(skiBytes);
    }

    public XMLX509SKI(Document doc, X509Certificate x509certificate) throws XMLSecurityException {
        super(doc);
        this.addBase64Text(XMLX509SKI.getSKIBytesFromCert(x509certificate));
    }

    public XMLX509SKI(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public byte[] getSKIBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public static byte[] getSKIBytesFromCert(X509Certificate cert) throws XMLSecurityException {
        try {
            byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
            if (cert.getVersion() < 3) {
                Object[] exArgs = new Object[]{new Integer(cert.getVersion())};
                throw new XMLSecurityException("certificate.noSki.lowVersion", exArgs);
            }
            byte[] extensionValue = null;
            try {
                DerValue dervalue = new DerValue(derEncodedValue);
                if (dervalue == null) {
                    throw new XMLSecurityException("certificate.noSki.null");
                }
                if (dervalue.tag != 4) {
                    throw new XMLSecurityException("certificate.noSki.notOctetString");
                }
                extensionValue = dervalue.getOctetString();
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
            if (extensionValue == null) {
                try {
                    Class<?> clazz = Class.forName("org.bouncycastle.asn1.DERInputStream");
                    if (clazz != null) {
                        Constructor<?> constructor = clazz.getConstructor(InputStream.class);
                        InputStream is = (InputStream)constructor.newInstance(new ByteArrayInputStream(derEncodedValue));
                        Method method = clazz.getMethod("readObject", new Class[0]);
                        Object obj = method.invoke(is, new Object[0]);
                        if (obj == null) {
                            throw new XMLSecurityException("certificate.noSki.null");
                        }
                        Class<?> clazz2 = Class.forName("org.bouncycastle.asn1.ASN1OctetString");
                        if (!clazz2.isInstance(obj)) {
                            throw new XMLSecurityException("certificate.noSki.notOctetString");
                        }
                        Method method2 = clazz2.getMethod("getOctets", new Class[0]);
                        extensionValue = (byte[])method2.invoke(obj, new Object[0]);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            byte[] abyte0 = new byte[extensionValue.length - 2];
            System.arraycopy(extensionValue, 2, abyte0, 0, abyte0.length);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Base64 of SKI is " + Base64.encode(abyte0));
            }
            return abyte0;
        }
        catch (IOException ex) {
            throw new XMLSecurityException("generic.EmptyMessage", ex);
        }
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        XMLX509SKI other = (XMLX509SKI)obj;
        try {
            return MessageDigest.isEqual(other.getSKIBytes(), this.getSKIBytes());
        }
        catch (XMLSecurityException ex) {
            return false;
        }
    }

    public String getBaseLocalName() {
        return "X509SKI";
    }
}

