/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.reflect.Constructor;
import java.security.PrivilegedExceptionAction;

class SystemClassLoaderAction
implements PrivilegedExceptionAction {
    private ClassLoader parent;

    SystemClassLoaderAction(ClassLoader parent) {
        this.parent = parent;
    }

    public Object run() throws Exception {
        Class[] cp = new Class[]{ClassLoader.class};
        Object[] params = new Object[]{this.parent};
        String cls = System.getProperty("java.system.class.loader");
        if (cls == null) {
            return this.parent;
        }
        Class<?> c = Class.forName(cls, true, this.parent);
        Constructor<?> ctor = c.getDeclaredConstructor(cp);
        ClassLoader sys = (ClassLoader)ctor.newInstance(params);
        Thread.currentThread().setContextClassLoader(sys);
        return sys;
    }
}

