/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSkipListMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8627078645895051609L;
    private static final Random seedGenerator = new Random();
    private static final Object BASE_HEADER = new Object();
    private volatile transient HeadIndex<K, V> head;
    private final Comparator<? super K> comparator;
    private transient int randomSeed;
    private transient KeySet keySet;
    private transient EntrySet entrySet;
    private transient Values values;
    private transient ConcurrentNavigableMap<K, V> descendingMap;
    private static final AtomicReferenceFieldUpdater<ConcurrentSkipListMap, HeadIndex> headUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentSkipListMap.class, HeadIndex.class, "head");
    private static final int EQ = 1;
    private static final int LT = 2;
    private static final int GT = 0;

    final void initialize() {
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.descendingMap = null;
        this.randomSeed = seedGenerator.nextInt() | 0x100;
        this.head = new HeadIndex(new Node(null, BASE_HEADER, null), null, null, 1);
    }

    private boolean casHead(HeadIndex<K, V> cmp, HeadIndex<K, V> val) {
        return headUpdater.compareAndSet(this, cmp, val);
    }

    private Comparable<? super K> comparable(Object key) throws ClassCastException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.comparator != null) {
            return new ComparableUsingComparator<K>(key, this.comparator);
        }
        return (Comparable)key;
    }

    int compare(K k1, K k2) throws ClassCastException {
        Comparator<K> cmp = this.comparator;
        if (cmp != null) {
            return cmp.compare(k1, k2);
        }
        return ((Comparable)k1).compareTo(k2);
    }

    boolean inHalfOpenRange(K key, K least, K fence) {
        if (key == null) {
            throw new NullPointerException();
        }
        return !(least != null && this.compare(key, least) < 0 || fence != null && this.compare(key, fence) >= 0);
    }

    boolean inOpenRange(K key, K least, K fence) {
        if (key == null) {
            throw new NullPointerException();
        }
        return !(least != null && this.compare(key, least) < 0 || fence != null && this.compare(key, fence) > 0);
    }

    private Node<K, V> findPredecessor(Comparable<? super K> key) {
        Index q;
        if (key == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            q = this.head;
            Index r = q.right;
            while (true) {
                Index d;
                if (r != null) {
                    Node n = r.node;
                    Object k = n.key;
                    if (n.value == null) {
                        if (!q.unlink(r)) continue block0;
                        r = q.right;
                        continue;
                    }
                    if (key.compareTo(k) > 0) {
                        q = r;
                        r = r.right;
                        continue;
                    }
                }
                if ((d = q.down) == null) break block0;
                q = d;
                r = d.right;
            }
            break;
        }
        return q.node;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Node<K, V> findNode(Comparable<? super K> key) {
        block0: while (true) {
            b /* !! */  = this.findPredecessor(key);
            n = b /* !! */ .next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b /* !! */ .next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b /* !! */ , f);
                    continue block0;
                }
                if (v != n && b /* !! */ .value != null) ** break;
                continue block0;
                c = key.compareTo(n.key);
                if (c == 0) {
                    return n;
                }
                if (c < 0) {
                    return null;
                }
                b /* !! */  = n;
                n = f;
            }
            break;
        }
    }

    private V doGet(Object okey) {
        int c;
        Object k;
        Node n;
        Comparable<K> key = this.comparable(okey);
        Node bound = null;
        Index q = this.head;
        Index r = q.right;
        while (true) {
            Index d;
            if (r != null && (n = r.node) != bound && (k = n.key) != null) {
                c = key.compareTo(k);
                if (c > 0) {
                    q = r;
                    r = r.right;
                    continue;
                }
                if (c == 0) {
                    Object v = n.value;
                    return (V)(v != null ? v : this.getUsingFindNode(key));
                }
                bound = n;
            }
            if ((d = q.down) == null) break;
            q = d;
            r = d.right;
        }
        n = q.node.next;
        while (n != null) {
            k = n.key;
            if (k != null) {
                c = key.compareTo(k);
                if (c == 0) {
                    Object v = n.value;
                    return (V)(v != null ? v : this.getUsingFindNode(key));
                }
                if (c < 0) break;
            }
            n = n.next;
        }
        return null;
    }

    private V getUsingFindNode(Comparable<? super K> key) {
        Node<? super K, V> n;
        Object v;
        do {
            if ((n = this.findNode(key)) != null) continue;
            return null;
        } while ((v = n.value) == null);
        return (V)v;
    }

    private V doPut(K kkey, V value, boolean onlyIfAbsent) {
        Node z;
        Comparable<K> key = this.comparable(kkey);
        block0: while (true) {
            Node b = this.findPredecessor(key);
            Node n = b.next;
            while (n != null) {
                Node f = n.next;
                if (n != b.next) continue block0;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                int c = key.compareTo(n.key);
                if (c > 0) {
                    b = n;
                    n = f;
                    continue;
                }
                if (c != 0) break;
                if (!onlyIfAbsent && !n.casValue(v, value)) continue block0;
                return (V)v;
            }
            if (b.casNext(n, z = new Node(kkey, value, n))) break;
        }
        int level = this.randomLevel();
        if (level > 0) {
            this.insertIndex(z, level);
        }
        return null;
    }

    private int randomLevel() {
        int x = this.randomSeed;
        x ^= x << 13;
        x ^= x >>> 17;
        x ^= x << 5;
        this.randomSeed = x;
        if ((x & 0x8001) != 0) {
            return 0;
        }
        int level = 1;
        while (((x >>>= 1) & 1) != 0) {
            ++level;
        }
        return level;
    }

    private void insertIndex(Node<K, V> z, int level) {
        HeadIndex<K, V> h = this.head;
        int max = h.level;
        if (level <= max) {
            Index<K, V> idx = null;
            for (int i = 1; i <= level; ++i) {
                idx = new Index<K, V>(z, idx, null);
            }
            this.addIndex(idx, h, level);
        } else {
            int k;
            HeadIndex<K, V> oldh;
            Index[] idxs;
            block7: {
                int oldLevel;
                HeadIndex<K, V> newh;
                level = max + 1;
                idxs = new Index[level + 1];
                Index<K, V> idx = null;
                for (int i = 1; i <= level; ++i) {
                    idxs[i] = idx = new Index<K, V>(z, idx, null);
                }
                do {
                    oldh = this.head;
                    oldLevel = oldh.level;
                    if (level <= oldLevel) {
                        k = level;
                        break block7;
                    }
                    newh = oldh;
                    Node oldbase = oldh.node;
                    for (int j = oldLevel + 1; j <= level; ++j) {
                        newh = new HeadIndex<K, V>(oldbase, newh, idxs[j], j);
                    }
                } while (!this.casHead(oldh, newh));
                k = oldLevel;
            }
            this.addIndex(idxs[k], oldh, k);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addIndex(Index<K, V> idx, HeadIndex<K, V> h, int indexLevel) {
        insertionLevel = indexLevel;
        key = this.comparable(idx.node.key);
        if (key == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            j = h.level;
            q = h;
            r = q.right;
            t = idx;
            while (true) {
                if (r != null) {
                    n = r.node;
                    c = key.compareTo(n.key);
                    if (n.value == null) {
                        if (!q.unlink(r)) continue block0;
                        r = q.right;
                        continue;
                    }
                    if (c > 0) {
                        q = r;
                        r = r.right;
                        continue;
                    }
                }
                if (j == insertionLevel) {
                    if (t.indexesDeletedNode()) {
                        this.findNode(key);
                        return;
                    }
                    if (q.link(r, t)) ** break;
                    continue block0;
                    if (--insertionLevel == 0) {
                        if (t.indexesDeletedNode()) {
                            this.findNode(key);
                        }
                        return;
                    }
                }
                if (--j >= insertionLevel && j < indexLevel) {
                    t = t.down;
                }
                q = q.down;
                r = q.right;
            }
            break;
        }
    }

    final V doRemove(Object okey, Object value) {
        Object v;
        Node f;
        Node n;
        Node b;
        Comparable<K> key = this.comparable(okey);
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                int c = key.compareTo(n.key);
                if (c < 0) {
                    return null;
                }
                if (c <= 0) break;
                b = n;
                n = f;
            }
            if (value != null && !value.equals(v)) {
                return null;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(key);
        } else {
            this.findPredecessor(key);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return (V)v;
    }

    private void tryReduceLevel() {
        HeadIndex e;
        HeadIndex d;
        HeadIndex<K, V> h = this.head;
        if (h.level > 3 && (d = (HeadIndex)h.down) != null && (e = (HeadIndex)d.down) != null && e.right == null && d.right == null && h.right == null && this.casHead(h, d) && h.right != null) {
            this.casHead(d, h);
        }
    }

    Node<K, V> findFirst() {
        while (true) {
            Node b = this.head.node;
            Node n = b.next;
            if (n == null) {
                return null;
            }
            if (n.value != null) {
                return n;
            }
            n.helpDelete(b, n.next);
        }
    }

    Map.Entry<K, V> doRemoveFirstEntry() {
        Object v;
        Node f;
        Node n;
        Node b;
        while (true) {
            b = this.head.node;
            n = b.next;
            if (n == null) {
                return null;
            }
            f = n.next;
            if (n != b.next) continue;
            v = n.value;
            if (v == null) {
                n.helpDelete(b, f);
                continue;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        return new AbstractMap.SimpleImmutableEntry(n.key, v);
    }

    private void clearIndexToFirst() {
        block0: while (true) {
            Index q = this.head;
            do {
                Index r;
                if ((r = q.right) != null && r.indexesDeletedNode() && !q.unlink(r)) continue block0;
            } while ((q = q.down) != null);
            break;
        }
        if (this.head.right == null) {
            this.tryReduceLevel();
        }
    }

    Node<K, V> findLast() {
        Index q = this.head;
        while (true) {
            Index r;
            if ((r = q.right) != null) {
                if (r.indexesDeletedNode()) {
                    q.unlink(r);
                    q = this.head;
                    continue;
                }
                q = r;
                continue;
            }
            Index d = q.down;
            if (d != null) {
                q = d;
                continue;
            }
            Node b = q.node;
            Node n = b.next;
            while (true) {
                if (n == null) {
                    return b.isBaseHeader() ? null : b;
                }
                Node f = n.next;
                if (n != b.next) break;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    break;
                }
                if (v == n || b.value == null) break;
                b = n;
                n = f;
            }
            q = this.head;
        }
    }

    private Node<K, V> findPredecessorOfLast() {
        Index q;
        block0: while (true) {
            q = this.head;
            while (true) {
                Index d;
                Index r;
                if ((r = q.right) != null) {
                    if (r.indexesDeletedNode()) {
                        q.unlink(r);
                        continue block0;
                    }
                    if (r.node.next != null) {
                        q = r;
                        continue;
                    }
                }
                if ((d = q.down) == null) break block0;
                q = d;
            }
            break;
        }
        return q.node;
    }

    Map.Entry<K, V> doRemoveLastEntry() {
        Object v;
        Node f;
        Node n;
        Node b;
        block0: while (true) {
            b = this.findPredecessorOfLast();
            n = b.next;
            if (n == null) {
                if (!b.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                if (f == null) break;
                b = n;
                n = f;
            }
            if (n.casValue(v, null)) break;
        }
        Object key = n.key;
        Comparable<K> ck = this.comparable(key);
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(ck);
        } else {
            this.findPredecessor(ck);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return new AbstractMap.SimpleImmutableEntry(key, v);
    }

    /*
     * Unable to fully structure code
     */
    Node<K, V> findNear(K kkey, int rel) {
        key = this.comparable(kkey);
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return (rel & 2) == 0 || b.isBaseHeader() != false ? null : b;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v != n && b.value != null) ** break;
                continue block0;
                c = key.compareTo(n.key);
                if (c == 0 && (rel & 1) != 0 || c < 0 && (rel & 2) == 0) {
                    return n;
                }
                if (c <= 0 && (rel & 2) != 0) {
                    return b.isBaseHeader() != false ? null : b;
                }
                b = n;
                n = f;
            }
            break;
        }
    }

    AbstractMap.SimpleImmutableEntry<K, V> getNear(K key, int rel) {
        Node<K, V> n;
        AbstractMap.SimpleImmutableEntry<K, V> e;
        do {
            if ((n = this.findNear(key, rel)) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    public ConcurrentSkipListMap() {
        this.comparator = null;
        this.initialize();
    }

    public ConcurrentSkipListMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.initialize();
    }

    public ConcurrentSkipListMap(Map<? extends K, ? extends V> m) {
        this.comparator = null;
        this.initialize();
        this.putAll(m);
    }

    public ConcurrentSkipListMap(SortedMap<K, ? extends V> m) {
        this.comparator = m.comparator();
        this.initialize();
        this.buildFromSorted(m);
    }

    @Override
    public ConcurrentSkipListMap<K, V> clone() {
        ConcurrentSkipListMap clone = null;
        try {
            clone = (ConcurrentSkipListMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.initialize();
        clone.buildFromSorted(this);
        return clone;
    }

    private void buildFromSorted(SortedMap<K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        HeadIndex<K, V> h = this.head;
        Node basepred = h.node;
        ArrayList preds = new ArrayList();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        for (Map.Entry<K, V> e : map.entrySet()) {
            int j = this.randomLevel();
            if (j > h.level) {
                j = h.level + 1;
            }
            K k = e.getKey();
            V v = e.getValue();
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            Node z = new Node(k, v, null);
            basepred.next = z;
            basepred = z;
            if (j <= 0) continue;
            Index idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex<K, V>(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<K, V> n = this.findFirst();
        while (n != null) {
            V v = n.getValidValue();
            if (v != null) {
                s.writeObject(n.key);
                s.writeObject(v);
            }
            n = n.next;
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object k;
        s.defaultReadObject();
        this.initialize();
        HeadIndex<Object, V> h = this.head;
        Node basepred = h.node;
        ArrayList preds = new ArrayList();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        while ((k = s.readObject()) != null) {
            Object v = s.readObject();
            if (v == null) {
                throw new NullPointerException();
            }
            Object key = k;
            Object val = v;
            int j = this.randomLevel();
            if (j > h.level) {
                j = h.level + 1;
            }
            Node z = new Node(key, val, null);
            basepred.next = z;
            basepred = z;
            if (j <= 0) continue;
            Index idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex<Object, V>(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.doGet(key) != null;
    }

    @Override
    public V get(Object key) {
        return this.doGet(key);
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doPut(key, value, false);
    }

    @Override
    public V remove(Object key) {
        return this.doRemove(key, null);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Node<K, V> n = this.findFirst();
        while (n != null) {
            V v = n.getValidValue();
            if (v != null && value.equals(v)) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    @Override
    public int size() {
        long count = 0L;
        Node<K, V> n = this.findFirst();
        while (n != null) {
            if (n.getValidValue() != null) {
                ++count;
            }
            n = n.next;
        }
        return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
    }

    @Override
    public boolean isEmpty() {
        return this.findFirst() == null;
    }

    @Override
    public void clear() {
        this.initialize();
    }

    @Override
    public NavigableSet<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet(this));
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet(this));
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(this));
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        ConcurrentNavigableMap<K, V> dm = this.descendingMap;
        return dm != null ? dm : (this.descendingMap = new SubMap(this, null, false, null, false, true));
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                if (e.getValue().equals(m.get(e.getKey()))) continue;
                return false;
            }
            for (Map.Entry<K, V> e : m.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (k != null && v != null && v.equals(this.get(k))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doPut(key, value, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return false;
        }
        return this.doRemove(key, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        Comparable<K> k = this.comparable(key);
        while (true) {
            Node<K, V> n;
            if ((n = this.findNode(k)) == null) {
                return false;
            }
            Object v = n.value;
            if (v == null) continue;
            if (!oldValue.equals(v)) {
                return false;
            }
            if (n.casValue(v, newValue)) break;
        }
        return true;
    }

    @Override
    public V replace(K key, V value) {
        Node<K, V> n;
        Object v;
        if (value == null) {
            throw new NullPointerException();
        }
        Comparable<K> k = this.comparable(key);
        do {
            if ((n = this.findNode(k)) != null) continue;
            return null;
        } while ((v = n.value) == null || !n.casValue(v, value));
        return (V)v;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        Node<K, V> n = this.findFirst();
        if (n == null) {
            throw new NoSuchElementException();
        }
        return n.key;
    }

    @Override
    public K lastKey() {
        Node<K, V> n = this.findLast();
        if (n == null) {
            throw new NoSuchElementException();
        }
        return n.key;
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, fromInclusive, toKey, toInclusive, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, null, false, toKey, inclusive, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, inclusive, null, false, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.getNear(key, 2);
    }

    @Override
    public K lowerKey(K key) {
        Node<K, V> n = this.findNear(key, 2);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.getNear(key, 3);
    }

    @Override
    public K floorKey(K key) {
        Node<K, V> n = this.findNear(key, 3);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.getNear(key, 1);
    }

    @Override
    public K ceilingKey(K key) {
        Node<K, V> n = this.findNear(key, 1);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.getNear(key, 0);
    }

    @Override
    public K higherKey(K key) {
        Node<K, V> n = this.findNear(key, 0);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Node<K, V> n;
        AbstractMap.SimpleImmutableEntry<K, V> e;
        do {
            if ((n = this.findFirst()) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Node<K, V> n;
        AbstractMap.SimpleImmutableEntry<K, V> e;
        do {
            if ((n = this.findLast()) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.doRemoveFirstEntry();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.doRemoveLastEntry();
    }

    Iterator<K> keyIterator() {
        return new KeyIterator();
    }

    Iterator<V> valueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return new EntryIterator();
    }

    static final <E> List<E> toList(Collection<E> c) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : c) {
            list.add(e);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = -7647078645895051609L;
        private final ConcurrentSkipListMap<K, V> m;
        private final K lo;
        private final K hi;
        private final boolean loInclusive;
        private final boolean hiInclusive;
        private final boolean isDescending;
        private transient KeySet<K> keySetView;
        private transient Set<Map.Entry<K, V>> entrySetView;
        private transient Collection<V> valuesView;

        SubMap(ConcurrentSkipListMap<K, V> map, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive, boolean isDescending) {
            if (fromKey != null && toKey != null && map.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("inconsistent range");
            }
            this.m = map;
            this.lo = fromKey;
            this.hi = toKey;
            this.loInclusive = fromInclusive;
            this.hiInclusive = toInclusive;
            this.isDescending = isDescending;
        }

        private boolean tooLow(K key) {
            int c;
            return this.lo != null && ((c = this.m.compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        private boolean tooHigh(K key) {
            int c;
            return this.hi != null && ((c = this.m.compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        private boolean inBounds(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void checkKeyBounds(K key) throws IllegalArgumentException {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        private boolean isBeforeEnd(Node<K, V> n) {
            if (n == null) {
                return false;
            }
            if (this.hi == null) {
                return true;
            }
            Object k = n.key;
            if (k == null) {
                return true;
            }
            int c = this.m.compare(k, this.hi);
            return c <= 0 && (c != 0 || this.hiInclusive);
        }

        private Node<K, V> loNode() {
            if (this.lo == null) {
                return this.m.findFirst();
            }
            if (this.loInclusive) {
                return this.m.findNear(this.lo, 0 | 1);
            }
            return this.m.findNear(this.lo, 0);
        }

        private Node<K, V> hiNode() {
            if (this.hi == null) {
                return this.m.findLast();
            }
            if (this.hiInclusive) {
                return this.m.findNear(this.hi, 2 | 1);
            }
            return this.m.findNear(this.hi, 2);
        }

        private K lowestKey() {
            Node<K, V> n = this.loNode();
            if (this.isBeforeEnd(n)) {
                return n.key;
            }
            throw new NoSuchElementException();
        }

        private K highestKey() {
            Object last;
            Node<K, V> n = this.hiNode();
            if (n != null && this.inBounds(last = n.key)) {
                return last;
            }
            throw new NoSuchElementException();
        }

        private Map.Entry<K, V> lowestEntry() {
            Node<K, V> n;
            AbstractMap.SimpleImmutableEntry<K, V> e;
            do {
                if (this.isBeforeEnd(n = this.loNode())) continue;
                return null;
            } while ((e = n.createSnapshot()) == null);
            return e;
        }

        private Map.Entry<K, V> highestEntry() {
            Node<K, V> n;
            AbstractMap.SimpleImmutableEntry<K, V> e;
            do {
                if ((n = this.hiNode()) != null && this.inBounds(n.key)) continue;
                return null;
            } while ((e = n.createSnapshot()) == null);
            return e;
        }

        private Map.Entry<K, V> removeLowest() {
            Object k;
            V v;
            do {
                Node<K, V> n;
                if ((n = this.loNode()) == null) {
                    return null;
                }
                k = n.key;
                if (this.inBounds(k)) continue;
                return null;
            } while ((v = this.m.doRemove(k, null)) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        private Map.Entry<K, V> removeHighest() {
            Object k;
            V v;
            do {
                Node<K, V> n;
                if ((n = this.hiNode()) == null) {
                    return null;
                }
                k = n.key;
                if (this.inBounds(k)) continue;
                return null;
            } while ((v = this.m.doRemove(k, null)) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        private Map.Entry<K, V> getNearEntry(K key, int rel) {
            Object k;
            Node<K, V> n;
            V v;
            if (this.isDescending) {
                rel = (rel & 2) == 0 ? (rel |= 2) : (rel &= ~2);
            }
            if (this.tooLow(key)) {
                return (rel & 2) != 0 ? null : this.lowestEntry();
            }
            if (this.tooHigh(key)) {
                return (rel & 2) != 0 ? this.highestEntry() : null;
            }
            do {
                if ((n = this.m.findNear(key, rel)) == null || !this.inBounds(n.key)) {
                    return null;
                }
                k = n.key;
            } while ((v = n.getValidValue()) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        private K getNearKey(K key, int rel) {
            Object k;
            Node<K, V> n;
            V v;
            if (this.isDescending) {
                rel = (rel & 2) == 0 ? (rel |= 2) : (rel &= ~2);
            }
            if (this.tooLow(key)) {
                Node<K, V> n2;
                if ((rel & 2) == 0 && this.isBeforeEnd(n2 = this.loNode())) {
                    return n2.key;
                }
                return null;
            }
            if (this.tooHigh(key)) {
                Object last;
                Node<K, V> n3;
                if ((rel & 2) != 0 && (n3 = this.hiNode()) != null && this.inBounds(last = n3.key)) {
                    return last;
                }
                return null;
            }
            do {
                if ((n = this.m.findNear(key, rel)) == null || !this.inBounds(n.key)) {
                    return null;
                }
                k = n.key;
            } while ((v = n.getValidValue()) == null);
            return k;
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return this.inBounds(k) && this.m.containsKey(k);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.remove(k);
        }

        @Override
        public int size() {
            long count = 0L;
            Node<K, V> n = this.loNode();
            while (this.isBeforeEnd(n)) {
                if (n.getValidValue() != null) {
                    ++count;
                }
                n = n.next;
            }
            return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
        }

        @Override
        public boolean isEmpty() {
            return !this.isBeforeEnd(this.loNode());
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Node<K, V> n = this.loNode();
            while (this.isBeforeEnd(n)) {
                V v = n.getValidValue();
                if (v != null && value.equals(v)) {
                    return true;
                }
                n = n.next;
            }
            return false;
        }

        @Override
        public void clear() {
            Node<K, V> n = this.loNode();
            while (this.isBeforeEnd(n)) {
                if (n.getValidValue() != null) {
                    this.m.remove(n.key);
                }
                n = n.next;
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inBounds(k) && this.m.remove(k, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKeyBounds(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator<K> cmp = this.m.comparator();
            if (this.isDescending) {
                return Collections.reverseOrder(cmp);
            }
            return cmp;
        }

        private SubMap<K, V> newSubMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (this.isDescending) {
                K tk = fromKey;
                fromKey = toKey;
                toKey = tk;
                boolean ti = fromInclusive;
                fromInclusive = toInclusive;
                toInclusive = ti;
            }
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    int c = this.m.compare(fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    int c = this.m.compare(toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new SubMap<K, V>(this.m, fromKey, fromInclusive, toKey, toInclusive, this.isDescending);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, toKey, inclusive);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, inclusive, null, false);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public SubMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }

        @Override
        public SubMap<K, V> descendingMap() {
            return new SubMap<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive, !this.isDescending);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            return this.getNearEntry(key, 0 | 1);
        }

        @Override
        public K ceilingKey(K key) {
            return this.getNearKey(key, 0 | 1);
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            return this.getNearEntry(key, 2);
        }

        @Override
        public K lowerKey(K key) {
            return this.getNearKey(key, 2);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            return this.getNearEntry(key, 2 | 1);
        }

        @Override
        public K floorKey(K key) {
            return this.getNearKey(key, 2 | 1);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            return this.getNearEntry(key, 0);
        }

        @Override
        public K higherKey(K key) {
            return this.getNearKey(key, 0);
        }

        @Override
        public K firstKey() {
            return this.isDescending ? this.highestKey() : this.lowestKey();
        }

        @Override
        public K lastKey() {
            return this.isDescending ? this.lowestKey() : this.highestKey();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.isDescending ? this.highestEntry() : this.lowestEntry();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.isDescending ? this.lowestEntry() : this.highestEntry();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return this.isDescending ? this.removeHighest() : this.removeLowest();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return this.isDescending ? this.removeLowest() : this.removeHighest();
        }

        @Override
        public NavigableSet<K> keySet() {
            KeySet<K> ks = this.keySetView;
            return ks != null ? ks : (this.keySetView = new KeySet(this));
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            KeySet<K> ks = this.keySetView;
            return ks != null ? ks : (this.keySetView = new KeySet(this));
        }

        @Override
        public Collection<V> values() {
            Collection<V> vs = this.valuesView;
            return vs != null ? vs : (this.valuesView = new Values<V>(this));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> es = this.entrySetView;
            return es != null ? es : (this.entrySetView = new EntrySet<K, V>(this));
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return ((SubMap)this.descendingMap()).navigableKeySet();
        }

        Iterator<K> keyIterator() {
            return new SubMapKeyIterator();
        }

        Iterator<V> valueIterator() {
            return new SubMapValueIterator();
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            return new SubMapEntryIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SubMapEntryIterator
        extends SubMapIter<Map.Entry<K, V>> {
            SubMapEntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                Node n = this.next;
                Object v = this.nextValue;
                this.advance();
                return new AbstractMap.SimpleImmutableEntry(n.key, v);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SubMapKeyIterator
        extends SubMapIter<K> {
            SubMapKeyIterator() {
            }

            @Override
            public K next() {
                Node n = this.next;
                this.advance();
                return n.key;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SubMapValueIterator
        extends SubMapIter<V> {
            SubMapValueIterator() {
            }

            @Override
            public V next() {
                Object v = this.nextValue;
                this.advance();
                return v;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        abstract class SubMapIter<T>
        implements Iterator<T> {
            Node<K, V> lastReturned;
            Node<K, V> next;
            V nextValue;

            SubMapIter() {
                block3: {
                    Object x;
                    do {
                        Node node = this.next = SubMap.this.isDescending ? SubMap.this.hiNode() : SubMap.this.loNode();
                        if (this.next == null) break block3;
                    } while ((x = this.next.value) == null || x == this.next);
                    if (!SubMap.this.inBounds(this.next.key)) {
                        this.next = null;
                    } else {
                        this.nextValue = x;
                    }
                }
            }

            @Override
            public final boolean hasNext() {
                return this.next != null;
            }

            final void advance() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.next;
                if (SubMap.this.isDescending) {
                    this.descend();
                } else {
                    this.ascend();
                }
            }

            private void ascend() {
                block3: {
                    Object x;
                    do {
                        this.next = this.next.next;
                        if (this.next == null) break block3;
                    } while ((x = this.next.value) == null || x == this.next);
                    if (SubMap.this.tooHigh(this.next.key)) {
                        this.next = null;
                    } else {
                        this.nextValue = x;
                    }
                }
            }

            private void descend() {
                block3: {
                    Object x;
                    do {
                        this.next = SubMap.this.m.findNear(this.lastReturned.key, 2);
                        if (this.next == null) break block3;
                    } while ((x = this.next.value) == null || x == this.next);
                    if (SubMap.this.tooLow(this.next.key)) {
                        this.next = null;
                    } else {
                        this.nextValue = x;
                    }
                }
            }

            @Override
            public void remove() {
                Node l = this.lastReturned;
                if (l == null) {
                    throw new IllegalStateException();
                }
                SubMap.this.m.remove(l.key);
                this.lastReturned = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EntrySet<K1, V1>
    extends AbstractSet<Map.Entry<K1, V1>> {
        private final ConcurrentNavigableMap<K1, V1> m;

        EntrySet(ConcurrentNavigableMap<K1, V1> map) {
            this.m = map;
        }

        @Override
        public Iterator<Map.Entry<K1, V1>> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).entryIterator();
            }
            return ((SubMap)this.m).entryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = this.m.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.m.remove(e.getKey(), e.getValue());
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ConcurrentSkipListMap.toList(this).toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Values<E>
    extends AbstractCollection<E> {
        private final ConcurrentNavigableMap<Object, E> m;

        Values(ConcurrentNavigableMap<Object, E> map) {
            this.m = map;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).valueIterator();
            }
            return ((SubMap)this.m).valueIterator();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsValue(o);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ConcurrentSkipListMap.toList(this).toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final ConcurrentNavigableMap<E, Object> m;

        KeySet(ConcurrentNavigableMap<E, Object> map) {
            this.m = map;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public E pollFirst() {
            Map.Entry e = this.m.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry e = this.m.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).keyIterator();
            }
            return ((SubMap)this.m).keyIterator();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ConcurrentSkipListMap.toList(this).toArray(a);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new ConcurrentSkipListSet<E>(this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new ConcurrentSkipListSet<E>(this.m.headMap(toElement, inclusive));
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new ConcurrentSkipListSet<E>(this.m.tailMap(fromElement, inclusive));
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public NavigableSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new ConcurrentSkipListSet<E>(this.m.descendingMap());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends Iter<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            Node n = this.next;
            Object v = this.nextValue;
            this.advance();
            return new AbstractMap.SimpleImmutableEntry(n.key, v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends Iter<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            Node n = this.next;
            this.advance();
            return n.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends Iter<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            Object v = this.nextValue;
            this.advance();
            return v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Iter<T>
    implements Iterator<T> {
        Node<K, V> lastReturned;
        Node<K, V> next;
        V nextValue;

        Iter() {
            block1: {
                Object x;
                do {
                    this.next = ConcurrentSkipListMap.this.findFirst();
                    if (this.next == null) break block1;
                } while ((x = this.next.value) == null || x == this.next);
                this.nextValue = x;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final void advance() {
            block2: {
                Object x;
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.next;
                do {
                    this.next = this.next.next;
                    if (this.next == null) break block2;
                } while ((x = this.next.value) == null || x == this.next);
                this.nextValue = x;
            }
        }

        @Override
        public void remove() {
            Node l = this.lastReturned;
            if (l == null) {
                throw new IllegalStateException();
            }
            ConcurrentSkipListMap.this.remove(l.key);
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ComparableUsingComparator<K>
    implements Comparable<K> {
        final K actualKey;
        final Comparator<? super K> cmp;

        ComparableUsingComparator(K key, Comparator<? super K> cmp) {
            this.actualKey = key;
            this.cmp = cmp;
        }

        @Override
        public int compareTo(K k2) {
            return this.cmp.compare(this.actualKey, k2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class HeadIndex<K, V>
    extends Index<K, V> {
        final int level;

        HeadIndex(Node<K, V> node, Index<K, V> down, Index<K, V> right, int level) {
            super(node, down, right);
            this.level = level;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Index<K, V> {
        final Node<K, V> node;
        final Index<K, V> down;
        volatile Index<K, V> right;
        static final AtomicReferenceFieldUpdater<Index, Index> rightUpdater = AtomicReferenceFieldUpdater.newUpdater(Index.class, Index.class, "right");

        Index(Node<K, V> node, Index<K, V> down, Index<K, V> right) {
            this.node = node;
            this.down = down;
            this.right = right;
        }

        final boolean casRight(Index<K, V> cmp, Index<K, V> val) {
            return rightUpdater.compareAndSet(this, cmp, val);
        }

        final boolean indexesDeletedNode() {
            return this.node.value == null;
        }

        final boolean link(Index<K, V> succ, Index<K, V> newSucc) {
            Node<K, V> n = this.node;
            newSucc.right = succ;
            return n.value != null && this.casRight(succ, newSucc);
        }

        final boolean unlink(Index<K, V> succ) {
            return !this.indexesDeletedNode() && this.casRight(succ, succ.right);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Node<K, V> {
        final K key;
        volatile Object value;
        volatile Node<K, V> next;
        static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
        static final AtomicReferenceFieldUpdater<Node, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "value");

        Node(K key, Object value, Node<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        Node(Node<K, V> next) {
            this.key = null;
            this.value = this;
            this.next = next;
        }

        boolean casValue(Object cmp, Object val) {
            return valueUpdater.compareAndSet(this, cmp, val);
        }

        boolean casNext(Node<K, V> cmp, Node<K, V> val) {
            return nextUpdater.compareAndSet(this, cmp, val);
        }

        boolean isMarker() {
            return this.value == this;
        }

        boolean isBaseHeader() {
            return this.value == BASE_HEADER;
        }

        boolean appendMarker(Node<K, V> f) {
            return this.casNext(f, new Node<K, V>(f));
        }

        void helpDelete(Node<K, V> b, Node<K, V> f) {
            if (f == this.next && this == b.next) {
                if (f == null || f.value != f) {
                    this.appendMarker(f);
                } else {
                    b.casNext(this, f.next);
                }
            }
        }

        V getValidValue() {
            Object v = this.value;
            if (v == this || v == BASE_HEADER) {
                return null;
            }
            return (V)v;
        }

        AbstractMap.SimpleImmutableEntry<K, V> createSnapshot() {
            V v = this.getValidValue();
            if (v == null) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry<K, V>(this.key, v);
        }
    }
}

