/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    private InputMap selectedWindowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static boolean crossMenuMnemonic = true;

    public static ComponentUI createUI(JComponent x) {
        return new BasicMenuUI();
    }

    static void loadActionMap(LazyActionMap map) {
        BasicMenuItemUI.loadActionMap(map);
        map.put(new Actions("selectMenu", null, true));
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateDefaultBackgroundColor();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIManager.getBoolean("Menu.crossMenuMnemonic");
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    void installLazyActionMap() {
        LazyActionMap.installLazyActionMap(this.menuItem, BasicMenuUI.class, this.getPropertyPrefix() + ".actionMap");
    }

    void updateMnemonicBinding() {
        int i;
        int mnemonic = this.menuItem.getModel().getMnemonic();
        int[] shortcutKeys = (int[])DefaultLookup.get(this.menuItem, this, "Menu.shortcutKeys");
        if (shortcutKeys == null) {
            shortcutKeys = new int[]{8};
        }
        if (mnemonic == this.lastMnemonic) {
            return;
        }
        InputMap windowInputMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (this.lastMnemonic != 0 && windowInputMap != null) {
            for (i = 0; i < shortcutKeys.length; ++i) {
                windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, shortcutKeys[i], false));
            }
        }
        if (mnemonic != 0) {
            if (windowInputMap == null) {
                windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, windowInputMap);
            }
            for (i = 0; i < shortcutKeys.length; ++i) {
                windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKeys[i], false), "selectMenu");
            }
        }
        this.lastMnemonic = mnemonic;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.lastMnemonic = 0;
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return this.getHandler();
    }

    protected MenuListener createMenuListener(JComponent c) {
        return null;
    }

    protected ChangeListener createChangeListener(JComponent c) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return this.getHandler();
    }

    BasicMenuItemUI.Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.menuListener = null;
        this.handler = null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return this.getHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return (MenuKeyListener)((Object)this.getHandler());
    }

    public Dimension getMaximumSize(JComponent c) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension d = c.getPreferredSize();
            return new Dimension(d.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected void setupPostTimer(JMenu menu) {
        Timer timer = new Timer(menu.getDelay(), new Actions("selectMenu", menu, false));
        timer.setRepeats(false);
        timer.start();
    }

    private static void appendPath(MenuElement[] path, MenuElement elem) {
        MenuElement[] newPath = new MenuElement[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        newPath[path.length] = elem;
        MenuSelectionManager.defaultManager().setSelectedPath(newPath);
    }

    private void updateDefaultBackgroundColor() {
        if (!UIManager.getBoolean("Menu.useMenuBarBackgroundForTopLevel")) {
            return;
        }
        JMenu menu = (JMenu)this.menuItem;
        if (menu.getBackground() instanceof UIResource) {
            if (menu.isTopLevelMenu()) {
                menu.setBackground(UIManager.getColor("MenuBar.background"));
            } else {
                menu.setBackground(UIManager.getColor(this.getPropertyPrefix() + ".background"));
            }
        }
    }

    private class Handler
    extends BasicMenuItemUI.Handler
    implements MenuKeyListener {
        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "mnemonic") {
                BasicMenuUI.this.updateMnemonicBinding();
            } else {
                if (e.getPropertyName().equals("ancestor")) {
                    BasicMenuUI.this.updateDefaultBackgroundColor();
                }
                super.propertyChange(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            MenuElement[] selectedPath;
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (menu.isTopLevelMenu()) {
                if (menu.isSelected() && menu.getPopupMenu().isShowing()) {
                    manager.clearSelectedPath();
                } else {
                    Container cnt = menu.getParent();
                    if (cnt != null && cnt instanceof JMenuBar) {
                        MenuElement[] me = new MenuElement[]{(MenuElement)((Object)cnt), menu};
                        manager.setSelectedPath(me);
                    }
                }
            }
            if ((selectedPath = manager.getSelectedPath()).length > 0 && selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                    BasicMenuUI.appendPath(selectedPath, menu.getPopupMenu());
                } else {
                    BasicMenuUI.this.setupPostTimer(menu);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
            if (!e.isConsumed()) {
                manager.clearSelectedPath();
            }
        }

        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (!menu.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable")) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        BasicMenuUI.appendPath(BasicMenuUI.this.getPath(), menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(BasicMenuUI.this.getPath());
                        BasicMenuUI.this.setupPostTimer(menu);
                    }
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[3];
                newPath[0] = (MenuElement)((Object)menu.getParent());
                newPath[1] = menu;
                if (BasicPopupMenuUI.getLastPopup() != null) {
                    newPath[2] = menu.getPopupMenu();
                }
                manager.setSelectedPath(newPath);
            }
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            Component comp;
            if (!BasicMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < BasicMenuUI.this.menuItem.getWidth() && p.y >= 0 && p.y < BasicMenuUI.this.menuItem.getHeight()) {
                JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
                MenuElement[] selectedPath = manager.getSelectedPath();
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.isTopLevelMenu() || menu.getDelay() == 0 || e.getID() == 506) {
                        BasicMenuUI.appendPath(path, menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(path);
                        BasicMenuUI.this.setupPostTimer(menu);
                    }
                }
            } else if (e.getID() == 502 && (comp = manager.componentForPoint(e.getComponent(), e.getPoint())) == null) {
                manager.clearSelectedPath();
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
            if (!crossMenuMnemonic && BasicPopupMenuUI.getLastPopup() != null) {
                return;
            }
            char key = Character.toLowerCase((char)BasicMenuUI.this.menuItem.getMnemonic());
            MenuElement[] path = e.getPath();
            MenuSelectionManager manager = e.getMenuSelectionManager();
            if (key == Character.toLowerCase(e.getKeyChar())) {
                JPopupMenu popupMenu = ((JMenu)BasicMenuUI.this.menuItem).getPopupMenu();
                ArrayList<MenuElement> newList = new ArrayList<MenuElement>(Arrays.asList(path));
                newList.add(popupMenu);
                MenuElement[] subs = popupMenu.getSubElements();
                MenuElement sub = BasicPopupMenuUI.findEnabledChild(subs, -1, true);
                if (sub != null) {
                    newList.add(sub);
                }
                MenuElement[] newPath = new MenuElement[]{};
                newPath = newList.toArray(newPath);
                manager.setSelectedPath(newPath);
                e.consume();
            } else if (((JMenu)BasicMenuUI.this.menuItem).isTopLevelMenu() && BasicPopupMenuUI.getLastPopup() == null) {
                manager.clearSelectedPath();
            }
        }

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public BasicMenuUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenu m, BasicMenuUI ui) {
            this.menu = m;
            this.ui = ui;
        }

        public void stateChanged(ChangeEvent e) {
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            BasicMenuUI.this.getHandler().mouseClicked(e);
        }

        public void mousePressed(MouseEvent e) {
            BasicMenuUI.this.getHandler().mousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            BasicMenuUI.this.getHandler().mouseReleased(e);
        }

        public void mouseEntered(MouseEvent e) {
            BasicMenuUI.this.getHandler().mouseEntered(e);
        }

        public void mouseExited(MouseEvent e) {
            BasicMenuUI.this.getHandler().mouseExited(e);
        }

        public void mouseDragged(MouseEvent e) {
            BasicMenuUI.this.getHandler().mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            BasicMenuUI.this.getHandler().mouseMoved(e);
        }
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT = "selectMenu";
        private JMenu menu;
        private boolean force = false;

        Actions(String key, JMenu menu, boolean shouldForce) {
            super(key);
            this.menu = menu;
            this.force = shouldForce;
        }

        private JMenu getMenu(ActionEvent e) {
            if (e.getSource() instanceof JMenu) {
                return (JMenu)e.getSource();
            }
            return this.menu;
        }

        public void actionPerformed(ActionEvent e) {
            JPopupMenu pm;
            JMenu menu = this.getMenu(e);
            if (!crossMenuMnemonic && (pm = BasicPopupMenuUI.getLastPopup()) != null && pm != menu.getParent()) {
                return;
            }
            MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container cnt = menu.getParent();
                if (cnt != null && cnt instanceof JMenuBar) {
                    MenuElement[] subElements = menu.getPopupMenu().getSubElements();
                    MenuElement[] me = subElements.length > 0 ? new MenuElement[]{(MenuElement)((Object)cnt), menu, menu.getPopupMenu(), subElements[0]} : new MenuElement[]{(MenuElement)((Object)cnt), menu, menu.getPopupMenu()};
                    defaultManager.setSelectedPath(me);
                }
            } else {
                MenuElement[] path = defaultManager.getSelectedPath();
                if (path.length > 0 && path[path.length - 1] == menu) {
                    BasicMenuUI.appendPath(path, menu.getPopupMenu());
                }
            }
        }

        public boolean isEnabled(Object c) {
            if (c instanceof JMenu) {
                return ((JMenu)c).isEnabled();
            }
            return true;
        }
    }
}

