/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.tools.JarSigner;
import sun.misc.JarIndex;

public class JNLPClassLoader
extends URLClassLoader {
    private static Map urlToLoader = new HashMap();
    private static int nativeCounter = 0;
    private File nativeDir = null;
    private AccessControlContext acc = AccessController.getContext();
    private List resourcePermissions;
    private ApplicationInstance app = null;
    private JNLPClassLoader[] loaders = null;
    private boolean strict = true;
    private ResourceTracker tracker = new ResourceTracker(true);
    private UpdatePolicy updatePolicy;
    private JNLPFile file;
    private ResourcesDesc resources;
    private SecurityDesc security;
    private ArrayList<Permission> runtimePermissions = new ArrayList();
    private List available = new ArrayList();
    private ArrayList<String> verifiedJars = null;
    private ArrayList<String> unverifiedJars = null;
    private JarSigner js = null;
    private boolean signing = false;
    private ArrayList<JarIndex> jarIndexes = new ArrayList();
    private TreeSet jarEntries = new TreeSet();

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    protected JNLPClassLoader(JNLPFile file, UpdatePolicy policy) throws LaunchException {
        super(new URL[0], JNLPClassLoader.class.getClassLoader());
        if (JNLPRuntime.isDebug()) {
            System.out.println("New classloader: " + file.getFileLocation());
        }
        this.file = file;
        this.updatePolicy = policy;
        this.resources = file.getResources();
        this.initializeExtensions();
        this.initializePermissions();
        this.initializeResources();
        this.setSecurity();
    }

    private void setSecurity() {
        this.security = this.file instanceof PluginBridge ? (this.signing ? new SecurityDesc(this.file, SecurityDesc.ALL_PERMISSIONS, this.file.getCodeBase().getHost()) : new SecurityDesc(this.file, SecurityDesc.SANDBOX_PERMISSIONS, this.file.getCodeBase().getHost())) : (this.signing ? this.file.getSecurity() : new SecurityDesc(this.file, SecurityDesc.SANDBOX_PERMISSIONS, this.file.getCodeBase().getHost()));
    }

    public static JNLPClassLoader getInstance(JNLPFile file, UpdatePolicy policy) throws LaunchException {
        JNLPClassLoader loader = null;
        URL location = file.getFileLocation();
        if (location != null) {
            loader = (JNLPClassLoader)urlToLoader.get(location);
        }
        if (loader == null) {
            loader = new JNLPClassLoader(file, policy);
        }
        if (file.getInformation().isSharingAllowed()) {
            urlToLoader.put(location, loader);
        }
        return loader;
    }

    public static JNLPClassLoader getInstance(URL location, UpdatePolicy policy) throws IOException, ParseException, LaunchException {
        JNLPClassLoader loader = (JNLPClassLoader)urlToLoader.get(location);
        if (loader == null) {
            loader = JNLPClassLoader.getInstance(new JNLPFile(location, false, policy), policy);
        }
        return loader;
    }

    void initializeExtensions() {
        ExtensionDesc[] ext = this.resources.getExtensions();
        ArrayList<JNLPClassLoader> loaderList = new ArrayList<JNLPClassLoader>();
        loaderList.add(this);
        for (int i = 0; i < ext.length; ++i) {
            try {
                JNLPClassLoader loader = JNLPClassLoader.getInstance(ext[i].getLocation(), this.updatePolicy);
                loaderList.add(loader);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.loaders = loaderList.toArray(new JNLPClassLoader[loaderList.size()]);
    }

    void initializePermissions() {
        this.resourcePermissions = new ArrayList();
        JARDesc[] jars = this.resources.getJARs();
        for (int i = 0; i < jars.length; ++i) {
            Permission p = CacheUtil.getReadPermission(jars[i].getLocation(), jars[i].getVersion());
            if (JNLPRuntime.isDebug()) {
                if (p == null) {
                    System.out.println("Unable to add permission for " + jars[i].getLocation());
                } else {
                    System.out.println("Permission added: " + p.toString());
                }
            }
            if (p == null) continue;
            this.resourcePermissions.add(p);
        }
    }

    void initializeResources() throws LaunchException {
        JARDesc[] jars = this.resources.getJARs();
        if (jars == null || jars.length == 0) {
            return;
        }
        ArrayList<JARDesc> initialJars = new ArrayList<JARDesc>();
        for (int i = 0; i < jars.length; ++i) {
            this.available.add(jars[i]);
            if (jars[i].isEager()) {
                initialJars.add(jars[i]);
            }
            this.tracker.addResource(jars[i].getLocation(), jars[i].getVersion(), jars[i].isCacheable() ? JNLPRuntime.getDefaultUpdatePolicy() : UpdatePolicy.FORCE);
        }
        if (this.strict) {
            this.fillInPartJars(initialJars);
        }
        if (JNLPRuntime.isVerifying()) {
            JarSigner js;
            this.waitForJars(initialJars);
            try {
                js = this.verifyJars(initialJars);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new LaunchException(null, null, JNLPClassLoader.R("LSFatal"), JNLPClassLoader.R("LCInit"), JNLPClassLoader.R("LFatalVerification"), JNLPClassLoader.R("LFatalVerificationInfo"));
            }
            if (js.anyJarsSigned()) {
                this.signing = true;
                if (!js.getAlreadyTrustPublisher()) {
                    if (!js.getRootInCacerts()) {
                        boolean b = SecurityWarningDialog.showCertWarningDialog(SecurityWarningDialog.AccessType.UNVERIFIED, this.file, js);
                        if (!b) {
                            throw new LaunchException(null, null, JNLPClassLoader.R("LSFatal"), JNLPClassLoader.R("LCLaunching"), JNLPClassLoader.R("LNotVerified"), "");
                        }
                    } else if (js.getRootInCacerts()) {
                        boolean b = false;
                        if (js.noSigningIssues()) {
                            b = SecurityWarningDialog.showCertWarningDialog(SecurityWarningDialog.AccessType.VERIFIED, this.file, js);
                        } else if (!js.noSigningIssues()) {
                            b = SecurityWarningDialog.showCertWarningDialog(SecurityWarningDialog.AccessType.SIGNING_ERROR, this.file, js);
                        }
                        if (!b) {
                            throw new LaunchException(null, null, JNLPClassLoader.R("LSFatal"), JNLPClassLoader.R("LCLaunching"), JNLPClassLoader.R("LCancelOnUserRequest"), "");
                        }
                    }
                }
            } else {
                this.signing = false;
            }
        }
        this.activateJars(initialJars);
    }

    public void enableCodeBase() {
        this.addURL(this.file.getCodeBase());
    }

    public void setApplication(ApplicationInstance app) {
        if (this.app != null) {
            if (JNLPRuntime.isDebug()) {
                IllegalStateException ex = new IllegalStateException("Application can only be set once");
                ex.printStackTrace();
            }
            return;
        }
        this.app = app;
    }

    public ApplicationInstance getApplication() {
        return this.app;
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        int i;
        Permissions result = new Permissions();
        if (this.security != null) {
            Enumeration<Permission> e = this.security.getPermissions().elements();
            while (e.hasMoreElements()) {
                result.add(e.nextElement());
            }
        }
        for (i = 0; i < this.resourcePermissions.size(); ++i) {
            result.add((Permission)this.resourcePermissions.get(i));
        }
        for (i = 0; i < this.runtimePermissions.size(); ++i) {
            result.add(this.runtimePermissions.get(i));
        }
        return result;
    }

    protected void addPermission(Permission p) {
        this.runtimePermissions.add(p);
    }

    protected void fillInPartJars(List jars) {
        for (int i = 0; i < jars.size(); ++i) {
            String part = ((JARDesc)jars.get(i)).getPart();
            for (int a = 0; a < this.available.size(); ++a) {
                JARDesc jar2 = (JARDesc)this.available.get(a);
                if (part == null || !part.equals(jar2.getPart()) || jars.contains(jar2)) continue;
                jars.add(jar2);
            }
        }
    }

    protected void activateJars(final List jars) {
        PrivilegedAction activate = new PrivilegedAction(){

            public Object run() {
                JNLPClassLoader.this.waitForJars(jars);
                for (int i = 0; i < jars.size(); ++i) {
                    JARDesc jar2;
                    block7: {
                        jar2 = (JARDesc)jars.get(i);
                        JNLPClassLoader.this.available.remove(jar2);
                        File localFile = JNLPClassLoader.this.tracker.getCacheFile(jar2.getLocation());
                        try {
                            JarIndex index;
                            URL location = jar2.getLocation();
                            if (localFile != null) {
                                location = localFile.toURL();
                                JarFile jarFile = new JarFile(localFile);
                                Enumeration<JarEntry> e = jarFile.entries();
                                while (e.hasMoreElements()) {
                                    JNLPClassLoader.this.jarEntries.add(e.nextElement().getName());
                                }
                            }
                            JNLPClassLoader.this.addURL(location);
                            if (localFile != null && (index = JarIndex.getJarIndex(new JarFile(localFile.getAbsolutePath()), null)) != null) {
                                JNLPClassLoader.this.jarIndexes.add(index);
                            }
                            if (JNLPRuntime.isDebug()) {
                                System.err.println("Activate jar: " + location);
                            }
                        }
                        catch (Exception ex) {
                            if (!JNLPRuntime.isDebug()) break block7;
                            ex.printStackTrace();
                        }
                    }
                    if (!jar2.isNative()) continue;
                    JNLPClassLoader.this.activateNative(jar2);
                }
                return null;
            }
        };
        AccessController.doPrivileged(activate, this.acc);
    }

    protected void activateNative(JARDesc jar2) {
        block6: {
            File localFile;
            if (JNLPRuntime.isDebug()) {
                System.out.println("Activate native: " + jar2.getLocation());
            }
            if ((localFile = this.tracker.getCacheFile(jar2.getLocation())) == null) {
                return;
            }
            if (this.nativeDir == null) {
                this.nativeDir = this.getNativeDir();
            }
            try {
                JarFile jarFile = new JarFile(localFile, false);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry e = entries.nextElement();
                    if (e.isDirectory() || e.getName().indexOf(47) != -1) continue;
                    File outFile = new File(this.nativeDir, e.getName());
                    CacheUtil.streamCopy(jarFile.getInputStream(e), new FileOutputStream(outFile));
                }
            }
            catch (IOException ex) {
                if (!JNLPRuntime.isDebug()) break block6;
                ex.printStackTrace();
            }
        }
    }

    protected File getNativeDir() {
        this.nativeDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "netx-native-" + (new Random().nextInt() & 0xFFFF));
        if (!this.nativeDir.mkdirs()) {
            return null;
        }
        return this.nativeDir;
    }

    @Override
    protected String findLibrary(String lib) {
        if (this.nativeDir == null) {
            return null;
        }
        String syslib = System.mapLibraryName(lib);
        File target = new File(this.nativeDir, syslib);
        if (target.exists()) {
            return target.toString();
        }
        String result = super.findLibrary(lib);
        if (result != null) {
            return result;
        }
        return this.findLibraryExt(lib);
    }

    protected String findLibraryExt(String lib) {
        for (int i = 0; i < this.loaders.length; ++i) {
            String result = null;
            if (this.loaders[i] != this) {
                result = this.loaders[i].findLibrary(lib);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void waitForJars(List jars) {
        URL[] urls = new URL[jars.size()];
        for (int i = 0; i < jars.size(); ++i) {
            JARDesc jar2 = (JARDesc)jars.get(i);
            urls[i] = jar2.getLocation();
        }
        CacheUtil.waitForResources(this.app, this.tracker, urls, this.file.getTitle());
    }

    private JarSigner verifyJars(List<JARDesc> jars) throws Exception {
        this.js = new JarSigner();
        this.js.verifyJars(jars, this.tracker);
        return this.js;
    }

    protected Class findLoadedClassAll(String name) {
        for (int i = 0; i < this.loaders.length; ++i) {
            Class result = null;
            result = this.loaders[i] == this ? super.findLoadedClass(name) : this.loaders[i].findLoadedClassAll(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class result = this.findLoadedClassAll(name);
        if (result == null) {
            try {
                ClassLoader parent = this.getParent();
                if (parent == null) {
                    parent = ClassLoader.getSystemClassLoader();
                }
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                result = this.loadClassExt(name);
            }
            catch (ClassNotFoundException cnfe) {
                for (JarIndex index : this.jarIndexes) {
                    LinkedList jarList = index.get(name.replace('.', '/'));
                    if (jarList == null) continue;
                    for (String jarName : jarList) {
                        URL u;
                        URL remoteURL;
                        JARDesc desc;
                        try {
                            desc = new JARDesc(new URL(this.file.getCodeBase(), jarName), null, null, false, true, false, true);
                        }
                        catch (MalformedURLException mfe) {
                            throw new ClassNotFoundException(name);
                        }
                        this.available.add(desc);
                        this.tracker.addResource(desc.getLocation(), desc.getVersion(), JNLPRuntime.getDefaultUpdatePolicy());
                        try {
                            remoteURL = new URL(this.file.getCodeBase() + jarName);
                        }
                        catch (MalformedURLException mfe) {
                            throw new ClassNotFoundException(name);
                        }
                        try {
                            u = this.tracker.getCacheURL(remoteURL);
                        }
                        catch (Exception e) {
                            throw new ClassNotFoundException(name);
                        }
                        if (u == null) continue;
                        this.addURL(u);
                    }
                    result = this.loadClassExt(name);
                }
            }
        }
        return result;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        for (int i = 0; i < this.loaders.length; ++i) {
            try {
                if (this.loaders[i] == this) {
                    return super.findClass(name);
                }
                return this.loaders[i].findClass(name);
            }
            catch (ClassNotFoundException ex) {
                continue;
            }
            catch (ClassFormatError classFormatError) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    private Class loadClassExt(String name) throws ClassNotFoundException {
        this.addAvailable();
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            while (true) {
                JNLPClassLoader addedTo;
                if ((addedTo = this.addNextResource()) == null) {
                    throw new ClassNotFoundException(name);
                }
                try {
                    return addedTo.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public URL getResource(String name) {
        URL result = super.getResource(name);
        for (int i = 1; i < this.loaders.length; ++i) {
            if (result != null) continue;
            result = this.loaders[i].getResource(name);
        }
        return result;
    }

    public Enumeration findResources(String name) throws IOException {
        Vector resources = new Vector();
        for (int i = 0; i < this.loaders.length; ++i) {
            Enumeration e = this.loaders[i] == this ? super.findResources(name) : this.loaders[i].findResources(name);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
        }
        return resources.elements();
    }

    public boolean resourceAvailableLocally(String s) {
        return this.jarEntries.contains(s);
    }

    protected void addAvailable() {
        for (int i = 1; i < this.loaders.length; ++i) {
            this.loaders[i].addAvailable();
        }
    }

    protected JNLPClassLoader addNextResource() {
        if (this.available.size() == 0) {
            for (int i = 1; i < this.loaders.length; ++i) {
                JNLPClassLoader result = this.loaders[i].addNextResource();
                if (result == null) continue;
                return result;
            }
            return null;
        }
        ArrayList jars = new ArrayList();
        jars.add(this.available.get(0));
        this.fillInPartJars(jars);
        this.activateJars(jars);
        return this;
    }

    public String getExtensionName() {
        String result = this.file.getInformation().getTitle();
        if (result == null) {
            result = this.file.getInformation().getDescription();
        }
        if (result == null && this.file.getFileLocation() != null) {
            result = this.file.getFileLocation().toString();
        }
        if (result == null && this.file.getCodeBase() != null) {
            result = this.file.getCodeBase().toString();
        }
        return result;
    }

    public String getExtensionHREF() {
        return this.file.getFileLocation().toString();
    }

    public boolean getSigning() {
        return this.signing;
    }

    protected SecurityDesc getSecurity() {
        return this.security;
    }
}

