/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.awt.image.GifFrame;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.NativeLibLoader;

public class GifImageDecoder
extends ImageDecoder {
    private static final boolean verbose = false;
    private static final int IMAGESEP = 44;
    private static final int EXBLOCK = 33;
    private static final int EX_GRAPHICS_CONTROL = 249;
    private static final int EX_COMMENT = 254;
    private static final int EX_APPLICATION = 255;
    private static final int TERMINATOR = 59;
    private static final int TRANSPARENCYMASK = 1;
    private static final int INTERLACEMASK = 64;
    private static final int COLORMAPMASK = 128;
    int num_global_colors;
    byte[] global_colormap;
    int trans_pixel = -1;
    IndexColorModel global_model;
    Hashtable props = new Hashtable();
    byte[] saved_image;
    IndexColorModel saved_model;
    int global_width;
    int global_height;
    int global_bgpixel;
    GifFrame curframe;
    private static final int normalflags = 30;
    private static final int interlaceflags = 29;
    private short[] prefix = new short[4096];
    private byte[] suffix = new byte[4096];
    private byte[] outCode = new byte[4097];

    public GifImageDecoder(InputStreamImageSource src, InputStream is) {
        super(src, is);
    }

    private static void error(String s1) throws ImageFormatException {
        throw new ImageFormatException(s1);
    }

    private int readBytes(byte[] buf, int off, int len) {
        while (len > 0) {
            try {
                int n = this.input.read(buf, off, len);
                if (n < 0) break;
                off += n;
                len -= n;
            }
            catch (IOException e) {
                break;
            }
        }
        return len;
    }

    private static final int ExtractByte(byte[] buf, int off) {
        return buf[off] & 0xFF;
    }

    private static final int ExtractWord(byte[] buf, int off) {
        return buf[off] & 0xFF | (buf[off + 1] & 0xFF) << 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceImage() throws IOException, ImageFormatException {
        try {
            this.readHeader();
            int totalframes = 0;
            int frameno = 0;
            int nloops = -1;
            int disposal_method = 0;
            int delay = -1;
            boolean loopsRead = false;
            boolean isAnimation = false;
            while (!this.aborted) {
                int code = this.input.read();
                switch (code) {
                    case 33: {
                        code = this.input.read();
                        switch (code) {
                            case 249: {
                                byte[] buf = new byte[6];
                                if (this.readBytes(buf, 0, 6) != 0) {
                                    return;
                                }
                                if (buf[0] != 4 || buf[5] != 0) {
                                    return;
                                }
                                delay = GifImageDecoder.ExtractWord(buf, 2) * 10;
                                if (delay > 0 && !isAnimation) {
                                    isAnimation = true;
                                    ImageFetcher.startingAnimation();
                                }
                                disposal_method = buf[1] >> 2 & 7;
                                if ((buf[1] & 1) != 0) {
                                    this.trans_pixel = GifImageDecoder.ExtractByte(buf, 4);
                                    break;
                                }
                                this.trans_pixel = -1;
                                break;
                            }
                            default: {
                                int n;
                                boolean loop_tag = false;
                                String comment = "";
                                while ((n = this.input.read()) > 0) {
                                    byte[] buf = new byte[n];
                                    if (this.readBytes(buf, 0, n) != 0) {
                                        return;
                                    }
                                    if (code == 254) {
                                        comment = comment + new String(buf, 0);
                                        continue;
                                    }
                                    if (code != 255) continue;
                                    if (loop_tag) {
                                        if (n == 3 && buf[0] == 1) {
                                            if (loopsRead) {
                                                GifImageDecoder.ExtractWord(buf, 1);
                                            } else {
                                                nloops = GifImageDecoder.ExtractWord(buf, 1);
                                                loopsRead = true;
                                            }
                                        } else {
                                            loop_tag = false;
                                        }
                                    }
                                    if (!"NETSCAPE2.0".equals(new String(buf, 0))) continue;
                                    loop_tag = true;
                                }
                                if (code == 254) {
                                    this.props.put("comment", comment);
                                }
                                if (!loop_tag || isAnimation) break;
                                isAnimation = true;
                                ImageFetcher.startingAnimation();
                                break;
                            }
                            case -1: {
                                return;
                            }
                        }
                        break;
                    }
                    case 44: {
                        if (!isAnimation) {
                            this.input.mark(0);
                        }
                        try {
                            if (!this.readImage(totalframes == 0, disposal_method, delay)) {
                                return;
                            }
                        }
                        catch (Exception e) {
                            return;
                        }
                        ++frameno;
                        ++totalframes;
                        break;
                    }
                    default: {
                        if (frameno == 0) {
                            return;
                        }
                    }
                    case 59: {
                        if (nloops == 0 || nloops-- >= 0) {
                            try {
                                if (this.curframe != null) {
                                    this.curframe.dispose();
                                    this.curframe = null;
                                }
                                this.input.reset();
                                this.saved_image = null;
                                this.saved_model = null;
                                frameno = 0;
                                break;
                            }
                            catch (IOException e) {
                                this.close();
                                return;
                            }
                        }
                        this.imageComplete(3, true);
                        return;
                    }
                }
            }
        }
        finally {
            this.close();
        }
    }

    private void readHeader() throws IOException, ImageFormatException {
        byte[] buf = new byte[13];
        if (this.readBytes(buf, 0, 13) != 0) {
            throw new IOException();
        }
        if (buf[0] != 71 || buf[1] != 73 || buf[2] != 70) {
            GifImageDecoder.error("not a GIF file.");
        }
        this.global_width = GifImageDecoder.ExtractWord(buf, 6);
        this.global_height = GifImageDecoder.ExtractWord(buf, 8);
        int ch = GifImageDecoder.ExtractByte(buf, 10);
        if ((ch & 0x80) == 0) {
            this.num_global_colors = 2;
            this.global_bgpixel = 0;
            this.global_colormap = new byte[6];
            this.global_colormap[2] = 0;
            this.global_colormap[1] = 0;
            this.global_colormap[0] = 0;
            this.global_colormap[5] = -1;
            this.global_colormap[4] = -1;
            this.global_colormap[3] = -1;
        } else {
            this.num_global_colors = 1 << (ch & 7) + 1;
            this.global_bgpixel = GifImageDecoder.ExtractByte(buf, 11);
            if (buf[12] != 0) {
                this.props.put("aspectratio", "" + (double)(GifImageDecoder.ExtractByte(buf, 12) + 15) / 64.0);
            }
            this.global_colormap = new byte[this.num_global_colors * 3];
            if (this.readBytes(this.global_colormap, 0, this.num_global_colors * 3) != 0) {
                throw new IOException();
            }
        }
        this.input.mark(Integer.MAX_VALUE);
    }

    private static native void initIDs();

    private native boolean parseImage(int var1, int var2, int var3, int var4, boolean var5, int var6, byte[] var7, byte[] var8, IndexColorModel var9);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int sendPixels(int x, int y, int width, int height, byte[] rasline, ColorModel model) {
        boolean save;
        int x2;
        int rasbeg;
        if (y < 0) {
            height += y;
            y = 0;
        }
        if (y + height > this.global_height) {
            height = this.global_height - y;
        }
        if (height <= 0) {
            return 1;
        }
        if (x < 0) {
            rasbeg = -x;
            width += x;
            x2 = 0;
        } else {
            rasbeg = 0;
            x2 = x;
        }
        if (x2 + width > this.global_width) {
            width = this.global_width - x2;
        }
        if (width <= 0) {
            return 1;
        }
        int rasend = rasbeg + width;
        int off = y * this.global_width + x2;
        boolean bl = save = this.curframe.disposal_method == 1;
        if (this.trans_pixel >= 0 && !this.curframe.initialframe) {
            if (this.saved_image != null && model.equals(this.saved_model)) {
                int i = rasbeg;
                while (i < rasend) {
                    byte pixel = rasline[i];
                    if ((pixel & 0xFF) == this.trans_pixel) {
                        rasline[i] = this.saved_image[off];
                    } else if (save) {
                        this.saved_image[off] = pixel;
                    }
                    ++i;
                    ++off;
                }
                return this.setPixels(x2, y, width, height, model, rasline, rasbeg, 0);
            }
            int runstart = -1;
            int count = 1;
            int i = rasbeg;
            while (i < rasend) {
                byte pixel = rasline[i];
                if ((pixel & 0xFF) == this.trans_pixel) {
                    if (runstart >= 0 && (count = this.setPixels(x + runstart, y, i - runstart, 1, model, rasline, runstart, 0)) == 0) break;
                    runstart = -1;
                } else {
                    if (runstart < 0) {
                        runstart = i;
                    }
                    if (save) {
                        this.saved_image[off] = pixel;
                    }
                }
                ++i;
                ++off;
            }
            if (runstart < 0) return count;
            return this.setPixels(x + runstart, y, rasend - runstart, 1, model, rasline, runstart, 0);
        }
        if (!save) return this.setPixels(x2, y, width, height, model, rasline, rasbeg, 0);
        System.arraycopy(rasline, rasbeg, this.saved_image, off, width);
        return this.setPixels(x2, y, width, height, model, rasline, rasbeg, 0);
    }

    private boolean readImage(boolean first, int disposal_method, int delay) throws IOException {
        if (this.curframe != null && !this.curframe.dispose()) {
            this.abort();
            return false;
        }
        long tm = 0L;
        byte[] block = new byte[259];
        if (this.readBytes(block, 0, 10) != 0) {
            throw new IOException();
        }
        int x = GifImageDecoder.ExtractWord(block, 0);
        int y = GifImageDecoder.ExtractWord(block, 2);
        int width = GifImageDecoder.ExtractWord(block, 4);
        int height = GifImageDecoder.ExtractWord(block, 6);
        if (width == 0 && this.global_width != 0) {
            width = this.global_width - x;
        }
        if (height == 0 && this.global_height != 0) {
            height = this.global_height - y;
        }
        boolean interlace = (block[8] & 0x40) != 0;
        IndexColorModel model = this.global_model;
        if ((block[8] & 0x80) != 0) {
            int num_local_colors = 1 << (block[8] & 7) + 1;
            byte[] local_colormap = new byte[num_local_colors * 3];
            local_colormap[0] = block[9];
            if (this.readBytes(local_colormap, 1, num_local_colors * 3 - 1) != 0) {
                throw new IOException();
            }
            if (this.readBytes(block, 9, 1) != 0) {
                throw new IOException();
            }
            if (this.trans_pixel >= num_local_colors) {
                num_local_colors = this.trans_pixel + 1;
                local_colormap = GifImageDecoder.grow_colormap(local_colormap, num_local_colors);
            }
            model = new IndexColorModel(8, num_local_colors, local_colormap, 0, false, this.trans_pixel);
        } else if (model == null || this.trans_pixel != model.getTransparentPixel()) {
            if (this.trans_pixel >= this.num_global_colors) {
                this.num_global_colors = this.trans_pixel + 1;
                this.global_colormap = GifImageDecoder.grow_colormap(this.global_colormap, this.num_global_colors);
            }
            this.global_model = model = new IndexColorModel(8, this.num_global_colors, this.global_colormap, 0, false, this.trans_pixel);
        }
        if (first) {
            if (this.global_width == 0) {
                this.global_width = width;
            }
            if (this.global_height == 0) {
                this.global_height = height;
            }
            this.setDimensions(this.global_width, this.global_height);
            this.setProperties(this.props);
            this.setColorModel(model);
            this.headerComplete();
        }
        if (disposal_method == 1 && this.saved_image == null) {
            byte tpix;
            this.saved_image = new byte[this.global_width * this.global_height];
            if (height < this.global_height && model != null && (tpix = (byte)model.getTransparentPixel()) >= 0) {
                byte[] trans_rasline = new byte[this.global_width];
                for (int i = 0; i < this.global_width; ++i) {
                    trans_rasline[i] = tpix;
                }
                this.setPixels(0, 0, this.global_width, y, (ColorModel)model, trans_rasline, 0, 0);
                this.setPixels(0, y + height, this.global_width, this.global_height - height - y, (ColorModel)model, trans_rasline, 0, 0);
            }
        }
        int hints = interlace ? 29 : 30;
        this.setHints(hints);
        this.curframe = new GifFrame(this, disposal_method, delay, this.curframe == null, model, x, y, width, height);
        byte[] rasline = new byte[width];
        boolean ret = this.parseImage(x, y, width, height, interlace, GifImageDecoder.ExtractByte(block, 9), block, rasline, model);
        if (!ret) {
            this.abort();
        }
        return ret;
    }

    public static byte[] grow_colormap(byte[] colormap, int newlen) {
        byte[] newcm = new byte[newlen * 3];
        System.arraycopy(colormap, 0, newcm, 0, colormap.length);
        return newcm;
    }

    static {
        NativeLibLoader.loadLibraries();
        GifImageDecoder.initIDs();
    }
}

