/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class SSLContextRMIServerSocketFactory
extends SslRMIServerSocketFactory {
    private SSLContext context;

    public SSLContextRMIServerSocketFactory(SSLContext context) {
        this(context, null, null, false);
    }

    public SSLContextRMIServerSocketFactory(SSLContext context, String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth) throws IllegalArgumentException {
        super(enabledCipherSuites, enabledProtocols, needClientAuth);
        this.context = context;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        if (this.context == null) {
            return super.createServerSocket(port);
        }
        final SSLSocketFactory sslSocketFactory = this.context.getSocketFactory();
        return new ServerSocket(port){

            public Socket accept() throws IOException {
                Socket socket = super.accept();
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sslSocket.setUseClientMode(false);
                if (SSLContextRMIServerSocketFactory.this.getEnabledCipherSuites() != null) {
                    sslSocket.setEnabledCipherSuites(SSLContextRMIServerSocketFactory.this.getEnabledCipherSuites());
                }
                if (SSLContextRMIServerSocketFactory.this.getEnabledProtocols() != null) {
                    sslSocket.setEnabledProtocols(SSLContextRMIServerSocketFactory.this.getEnabledProtocols());
                }
                sslSocket.setNeedClientAuth(SSLContextRMIServerSocketFactory.this.getNeedClientAuth());
                return sslSocket;
            }
        };
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SSLContextRMIServerSocketFactory that = (SSLContextRMIServerSocketFactory)obj;
        return this.context == null ? that.context == null : this.context.equals(that.context);
    }

    public int hashCode() {
        return super.hashCode() + (this.context == null ? 0 : this.context.hashCode());
    }
}

