/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import sun.security.action.GetIntegerAction;

public final class InetAddressCachePolicy {
    private static final String cachePolicyProp = "networkaddress.cache.ttl";
    private static final String cachePolicyPropFallback = "sun.net.inetaddr.ttl";
    private static final String negativeCachePolicyProp = "networkaddress.cache.negative.ttl";
    private static final String negativeCachePolicyPropFallback = "sun.net.inetaddr.negative.ttl";
    public static final int FOREVER = -1;
    public static final int NEVER = 0;
    public static final int DEFAULT_POSITIVE = 30;
    private static int cachePolicy;
    private static int negativeCachePolicy;
    private static boolean set;
    private static boolean negativeSet;

    public static synchronized int get() {
        if (!set && System.getSecurityManager() == null) {
            return 30;
        }
        return cachePolicy;
    }

    public static synchronized int getNegative() {
        return negativeCachePolicy;
    }

    public static synchronized void setIfNotSet(int newPolicy) {
        if (!set) {
            InetAddressCachePolicy.checkValue(newPolicy, cachePolicy);
            cachePolicy = newPolicy;
        }
    }

    public static synchronized void setNegativeIfNotSet(int newPolicy) {
        if (!negativeSet) {
            negativeCachePolicy = newPolicy;
        }
    }

    private static void checkValue(int newPolicy, int oldPolicy) {
        if (newPolicy == -1) {
            return;
        }
        if (oldPolicy == -1 || newPolicy < oldPolicy || newPolicy < -1) {
            throw new SecurityException("can't make InetAddress cache more lax");
        }
    }

    static {
        set = false;
        negativeSet = false;
        set = false;
        negativeSet = false;
        cachePolicy = -1;
        negativeCachePolicy = 0;
        Integer tmp = null;
        try {
            tmp = new Integer(AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty(InetAddressCachePolicy.cachePolicyProp);
                }
            }));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (tmp != null) {
            cachePolicy = tmp;
            if (cachePolicy < 0) {
                cachePolicy = -1;
            }
            set = true;
        } else {
            tmp = AccessController.doPrivileged(new GetIntegerAction(cachePolicyPropFallback));
            if (tmp != null) {
                cachePolicy = tmp;
                if (cachePolicy < 0) {
                    cachePolicy = -1;
                }
                set = true;
            }
        }
        try {
            tmp = new Integer(AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty(InetAddressCachePolicy.negativeCachePolicyProp);
                }
            }));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (tmp != null) {
            negativeCachePolicy = tmp;
            if (negativeCachePolicy < 0) {
                negativeCachePolicy = -1;
            }
            negativeSet = true;
        } else {
            tmp = AccessController.doPrivileged(new GetIntegerAction(negativeCachePolicyPropFallback));
            if (tmp != null) {
                negativeCachePolicy = tmp;
                if (negativeCachePolicy < 0) {
                    negativeCachePolicy = -1;
                }
                negativeSet = true;
            }
        }
    }
}

