/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import sun.rmi.runtime.Log;
import sun.rmi.transport.DGCImpl;

class WeakRef
extends WeakReference {
    private int hashValue;
    private Object strongRef = null;

    public WeakRef(Object obj) {
        super(obj);
        this.setHashValue(obj);
    }

    public WeakRef(Object obj, ReferenceQueue q) {
        super(obj, q);
        this.setHashValue(obj);
    }

    public synchronized void pin() {
        if (this.strongRef == null) {
            this.strongRef = this.get();
            if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
                DGCImpl.dgcLog.log(Log.VERBOSE, "strongRef = " + this.strongRef);
            }
        }
    }

    public synchronized void unpin() {
        if (this.strongRef != null) {
            if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
                DGCImpl.dgcLog.log(Log.VERBOSE, "strongRef = " + this.strongRef);
            }
            this.strongRef = null;
        }
    }

    private void setHashValue(Object obj) {
        this.hashValue = obj != null ? System.identityHashCode(obj) : 0;
    }

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WeakRef) {
            if (obj == this) {
                return true;
            }
            Object referent = this.get();
            return referent != null && referent == ((WeakRef)obj).get();
        }
        return false;
    }
}

