#!/usr/bin/python
import dbus
import dbus.glib
import gobject
import subprocess

network_connected = False
system_active = True

def powersave():
    global system_active, network_connected
    #print "Powersave check " + str(network_connected) + "  :: " + str(system_active)
    if network_connected and not system_active:
      #print "Passive mode, setting 200u"
      subprocess.call(["iwconfig", "wlan0", "power", "200u", "multicast"])
    if network_connected and system_active:
      #print "Active mode, setting 100u"
      subprocess.call(["iwconfig", "wlan0", "power", "100u", "multicast"])

def system_activity(state):
    global system_active
    
    #print "Got system activity " + str(state)
    if state == 1:
      system_active = True
    else:
      system_active = False

    powersave()

def device_active(path, wlan):
    global network_connected
    
    #print "Device active: " + str(path)
    if path.find("/wlan0") != -1:
      network_connected = True
      powersave()

def device_deactivated(path):
    global network_connected
    
    #print "Device inactive" + str(path)
    if path.find("/wlan0") != -1:
      network_connected = False
      powersave()

system_bus = dbus.SystemBus()
system_bus.add_signal_receiver(system_activity, 'SystemActivity', 'org.tspre.dsme')
system_bus.add_signal_receiver(device_active, 'DeviceNowActive', 'org.freedesktop.NetworkManager')
system_bus.add_signal_receiver(device_deactivated, 'DeviceDeactivated', 'org.freedesktop.NetworkManager')

subprocess.call(["iwconfig", "wlan0", "power", "on"])

gobject.MainLoop().run()
