#! /usr/bin/env python

import gobject
import gtk
import commands
import string
from wlan_xpm import WL
import dbus
from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)
import gobject
import conic

class NetStat():
    def __init__(self):

        self.strength_zero = 4294967179
        self.strength_fifty = 4294967229
        self.strength_hundred = 4294967279
        self.signal_strength = self.strength_zero
        self.iap_id = None
        self.connection = None
        self.status = None

        self.connection = conic.Connection()
        self.connection.connect("connection-event", self.connection_cb, 0xFFAA)
        self.connection.connect("statistics", self.statistics_cb, 0x55AA)
        self.connection.set_property("automatic-connection-events", True)
        # self.connection.request_connection(conic.CONNECT_FLAG_NONE)

        self.i = 5
        self.statusIcon = gtk.StatusIcon()
        self.statusIcon.connect('activate', self.on_activate)
        self.wls = WL()
        self.chknet()
        #gobject.timeout_add(30000, self.chknet)

    def on_activate(self, si):
        self.clicked_icon()

    def chknet(self):
        self.i = 0
        if self.status == conic.STATUS_CONNECTED:
           self.connection.statistics(self.iap_id)
           self.signal_pct = (self.signal_strength - self.strength_zero)
           self.i = int(round(self.signal_pct / 20,0))
           if self.signal_pct > 0:
              self.i += 1
           print "signal_strength=%i (%i pct, %i/5)" % (self.signal_strength, self.signal_pct, self.i)
        elif self.status == conic.STATUS_DISCONNECTED:
           self.i = 6          
        elif self.status == conic.STATUS_DISCONNECTING:
           self.i = 0

        wl = gtk.gdk.pixbuf_new_from_xpm_data(self.wls.get_pixbuf(self.i))
        self.statusIcon.set_from_pixbuf(wl)
        if not self.i:
            self.statusIcon.set_blinking(True)
        else:
            self.statusIcon.set_blinking(False)

        return self.i >= 0

    def clicked_icon(self):
        self.i = 5
        self.chknet()
        if self.status == conic.STATUS_CONNECTED:
           str1="CONNECTED to %s (%s mode)\nSignal strength: %i percent, (%i/5)" % (self.iap_name, self.bearer, self.signal_pct, self.i)
           str2=''
           # str2="Signal strength=%i (%i pct, %i/5)" % (self.signal_strength, self.signal_pct, self.i)
        elif self.status == conic.STATUS_DISCONNECTED:
           str1="DISCONNECTED" 
           str2=''
        elif self.status == conic.STATUS_DISCONNECTING:
           str1="DISCONNECTING (%s, %s)" % (self.iap_name, self.bearer)
           str2=''
        w = gtk.Window()
        w.set_title('Connection')
        w.connect('destroy', self.on_ok_clicked, w)
        w.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_DIALOG)

        l1 = gtk.Label(str1)
        #l2 = gtk.Label(str2)
        hboxu = gtk.HBox(True, 0)
        hboxu.pack_start(l1, False, False, 10)
        #hboxu.pack_start(l2, False, False, 10)

        b = gtk.Button('OK', gtk.STOCK_OK)
        b.connect('clicked', self.on_ok_clicked, w)
        bq = gtk.Button('Quit', gtk.STOCK_QUIT)
        bq.connect('clicked', gtk.main_quit)
        hboxd = gtk.HBox(True, 0)
        hboxd.pack_start(b, False, False, 0)
        if self.status == conic.STATUS_DISCONNECTED:
          brc = gtk.Button('Reconnect', gtk.STOCK_CONNECT)
          brc.connect('clicked', self.reconnect, w)
          hboxd.pack_start(brc, False, False, 0)

        hboxd.pack_start(bq, False, False, 0)

        vbox = gtk.VBox(False, 0)
        vbox.pack_start(hboxu, False, False, 20)
        vbox.pack_start(hboxd, False, False, 20)
        w.add(vbox)

        w.show_all() 

    def on_ok_clicked(self, button, window):
        window.hide()

    def reconnect(self, button, window):
        self.connection.request_connection(conic.CONNECT_FLAG_NONE)       
        window.hide()

    def statistics_cb(self, connection, event, data):
        self.signal_strength = event.get_signal_strength()
        self.time_active = event.get_time_active()
        self.rx_bytes = event.get_rx_bytes()
        self.tx_bytes = event.get_tx_bytes()

        #print "statistics(%s, %s, %x)" % (connection, event, data)
    
        #print "time active=%i" % self.time_active
        #print "signal_strength=%i" % self.signal_strength
        #print "rx_packets=%u" % event.get_rx_packets()
        #print "tx_packets=%u" % event.get_tx_packets()
        #print "rx_bytes=%u" % self.rx_bytes
        #print "tx_bytes=%u" % self.tx_bytes

    def connection_cb(self, connection, event, data):
    
        print "connection_cb(%s, %s, %x)" % (connection, event, data)

        self.status = event.get_status()
        self.error = event.get_error()
        self.iap_id = event.get_iap_id()
        self.bearer = event.get_bearer_type()
    
        if self.status == conic.STATUS_CONNECTED:
           self.iap_name = commands.getoutput("gconftool -g /system/osso/connectivity/IAP/"+self.iap_id+"/name")
           print "CONNECTED (%s, %s, %i, %i)" % (self.iap_name, self.bearer, self.status, self.error)
           #self.chknet()
           self.connection.statistics(self.iap_id)
           gobject.timeout_add(30000, self.chknet)
        elif self.status == conic.STATUS_DISCONNECTED:
           self.iap_name = "None"
           print "DISCONNECTED (%i, %i)" % (self.status, self.error)
        elif self.status == conic.STATUS_DISCONNECTING:
           print "DISCONNECTING (%s, %s, %i, %i)" % (self.iap_name, self.bearer, self.status, self.error)
   
        self.chknet()

if __name__ == "__main__":
    bus = dbus.SystemBus(private=True)    
    tbd = NetStat()
    gtk.main()
